import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/utility/utility.service";
import * as i2 from "primeng/inputtext";
import * as i3 from "@angular/common";
import * as i4 from "@angular/forms";
import * as i5 from "@ngx-translate/core";
/**
 * component input text
 */
export class PrgInputTextComponent {
    /**
     * Constructor
     * @param {UtilityService} utilityService
     */
    constructor(utilityService) {
        this.utilityService = utilityService;
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
        /**
         * Debounced method onChanged
         * @type {(args?: any) => void}
         */
        this.debounceOnChanged = this.utilityService.debounce((event) => {
            this.onChanged(event);
        }, 500);
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgInputTextComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputTextComponent, deps: [{ token: i1.UtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgInputTextComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputTextComponent, selector: "prg-input-text-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n    <input\r\n      pInputText\r\n      type=\"text\"\r\n      [formControlName]=\"configs?.key\"\r\n      [id]=\"configs?.key\"\r\n      [attr.disabled]=\"configs.disabled?configs.disabled:null\"\r\n      [readonly]=\"configs.readonly\"\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n      [name]=\"configs.key + '.name' | translate\"\r\n      (ngModelChange)=\"debounceOnChanged($event)\"\r\n\r\n\r\n    />\r\n    <label for=\"{{configs.key}}\">{{\r\n      configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n    }}</label>\r\n  </span>\r\n</span>\r\n", dependencies: [{ kind: "directive", type: i2.InputText, selector: "[pInputText]" }, { kind: "directive", type: i3.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i3.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i4.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i4.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputTextComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-text-field', template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n    <input\r\n      pInputText\r\n      type=\"text\"\r\n      [formControlName]=\"configs?.key\"\r\n      [id]=\"configs?.key\"\r\n      [attr.disabled]=\"configs.disabled?configs.disabled:null\"\r\n      [readonly]=\"configs.readonly\"\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n      [name]=\"configs.key + '.name' | translate\"\r\n      (ngModelChange)=\"debounceOnChanged($event)\"\r\n\r\n\r\n    />\r\n    <label for=\"{{configs.key}}\">{{\r\n      configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n    }}</label>\r\n  </span>\r\n</span>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.UtilityService }]; }, propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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