import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
/**
 * Class Input Text
 */
export class InputTextAreaConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputTextArea;
        /*
        /!**
         * When present, it specifies that the element should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         * When present, textarea size changes as being typed.
         */
        this.autoResize = false;
        /**
         * textarea number of rows.
         */
        this.rows = 0;
        /**
         * textarea number of columns.
         */
        this.cols = 0;
        Object.assign(this, init);
    }
}
//# sourceMappingURL=data:application/json;base64,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