import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/utility/utility.service";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "primeng/inputtextarea";
import * as i5 from "@ngx-translate/core";
/**
 * component input text area
 */
export class PrgInputTextAreaComponent {
    /**
     * Constructor
     * @param {UtilityService} utilityService
     */
    constructor(utilityService) {
        this.utilityService = utilityService;
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
        /**
         * Debounced method onChanged
         * @type {(args?: any) => void}
         */
        this.debounceOnChanged = this.utilityService.debounce((event) => {
            this.onChanged(event);
        }, 500);
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgInputTextAreaComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputTextAreaComponent, deps: [{ token: i1.UtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgInputTextAreaComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputTextAreaComponent, selector: "prg-input-text-area-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n    <textarea\r\n      type=\"text\"\r\n      [id]=\"configs.key\"\r\n      [formControlName]=\"configs.key\"\r\n      [cols]=\"configs.cols\"\r\n      [rows]=\"configs.rows\"\r\n      [attr.disabled]=\"configs.disabled?configs.disabled:null\"\r\n      [readonly]=\"configs.readonly\"\r\n      [autoResize]=\"configs.autoResize\"\r\n      pInputTextarea\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n      (ngModelChange)=\"debounceOnChanged($event)\"\r\n      [name]=\"configs.key + '.name' | translate\">\r\n    </textarea>\r\n    <label for=\"{{configs.key}}\">{{  configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n      }}</label>\r\n  </span>\r\n</span>\r\n", dependencies: [{ kind: "directive", type: i2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.InputTextarea, selector: "[pInputTextarea]", inputs: ["autoResize"], outputs: ["onResize"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputTextAreaComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-text-area-field', template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n    <textarea\r\n      type=\"text\"\r\n      [id]=\"configs.key\"\r\n      [formControlName]=\"configs.key\"\r\n      [cols]=\"configs.cols\"\r\n      [rows]=\"configs.rows\"\r\n      [attr.disabled]=\"configs.disabled?configs.disabled:null\"\r\n      [readonly]=\"configs.readonly\"\r\n      [autoResize]=\"configs.autoResize\"\r\n      pInputTextarea\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n      (ngModelChange)=\"debounceOnChanged($event)\"\r\n      [name]=\"configs.key + '.name' | translate\">\r\n    </textarea>\r\n    <label for=\"{{configs.key}}\">{{  configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n      }}</label>\r\n  </span>\r\n</span>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.UtilityService }]; }, propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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