import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/inputswitch";
/**
 * Class Input Switch
 */
export class InputSwitchConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputSwitch;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the input element.
         */
        this.inputId = null;
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.ariaLabel = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetInputSwitchConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * Input Switch configs and assign configs to element
     */
    set setInputSwitchConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputSwitchConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputSwitchConfigsDirective, deps: [{ token: i1.InputSwitch }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputSwitchConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputSwitchConfigsDirective, selector: "[setInputSwitchConfigs]", inputs: { setInputSwitchConfigs: "setInputSwitchConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputSwitchConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputSwitchConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.InputSwitch }]; }, propDecorators: { setInputSwitchConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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