import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/inputswitch";
import * as i3 from "@angular/forms";
import * as i4 from "./input-switch.model";
import * as i5 from "@ngx-translate/core";
/**
 * component Input Switch
 */
export class PrgInputSwitchComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.checked,
            }));
        }
    }
}
PrgInputSwitchComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputSwitchComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgInputSwitchComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputSwitchComponent, selector: "prg-input-switch-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n  <p-inputSwitch\r\n    (onChange)=\"onChanged($event)\"\r\n    [setInputSwitchConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs.key\"\r\n    [name]=\"configs.key + '.name' | translate\"></p-inputSwitch>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n", dependencies: [{ kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.InputSwitch, selector: "p-inputSwitch", inputs: ["style", "styleClass", "tabindex", "inputId", "name", "disabled", "readonly", "trueValue", "falseValue", "ariaLabel", "ariaLabelledBy"], outputs: ["onChange"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetInputSwitchConfigsDirective, selector: "[setInputSwitchConfigs]", inputs: ["setInputSwitchConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputSwitchComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-switch-field', template: "<div class=\"field-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n  <p-inputSwitch\r\n    (onChange)=\"onChanged($event)\"\r\n    [setInputSwitchConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs.key\"\r\n    [name]=\"configs.key + '.name' | translate\"></p-inputSwitch>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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