import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/inputnumber";
/**
 * Class Input Fiels
 */
export class InputNumberConfiguration extends BaseField {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputNumber;
        /**
         *Whether to format the value.
         */
        this.format = true;
        /**
         *Displays spinner buttons.
         */
        this.showButtons = false;
        /**
         *Layout of the buttons, valid values are stacked (default), horizontal and vertical.
         */
        this.buttonLayout = 'stacked';
        /**
         *Style class of the increment button.
         */
        this.incrementButtonClass = null;
        /**
         *Style class of the decrement button.
         */
        this.decrementButtonClass = null;
        /**
         *Style class of the increment button.
         */
        this.incrementButtonIcon = 'pi pi-chevron-up';
        /**
         *Style class of the decrement button.
         */
        this.decrementButtonIcon = 'pi pi-chevron-down';
        /**
         *Locale to be used in formatting.
         */
        this.locale = undefined;
        /**
         *The locale matching algorithm to use. Possible values are lookup and best fit; the default is best fit. See Locale Negotation for details.
         */
        this.localeMatcher = 'best fit';
        /**
         *Defines the behavior of the component, valid values are decimal and currency.
         */
        this.mode = 'decimal';
        /**
         *Text to display before the value.
         */
        this.prefix = null;
        /**
         *Text to display after the value.
         */
        this.suffix = null;
        /**
         *The currency to use in currency formatting. Possible values are the ISO 4217 currency codes, such as USD for the US dollar, EUR for the euro, or CNY for the Chinese RMB. There is no default value; if the style is currency, the currency property must be provided.
         */
        this.currency = undefined;
        /**
         *How to display the currency in currency formatting. Possible values are symbol to use a localized currency symbol such as €, ücode to use the ISO currency code, name to use a localized currency name such as dollar; the default is symbol.
         */
        this.currencyDisplay = 'symbol';
        /**
         *Whether to use grouping separators, such as thousands separators or thousand/lakh/crore separators.
         */
        this.useGrouping = true;
        /**
         *The minimum number of fraction digits to use. Possible values are from 0 to 20; the default for plain number and percent formatting is 0; the default for currency formatting is the number of minor unit digits provided by the ISO 4217 currency code list (2 if the list doesn't provide that information).
         */
        this.minFractionDigits = null;
        /**
         *The maximum number of fraction digits to use. Possible values are from 0 to 20; the default for plain number formatting is the larger of minimumFractionDigits and 3; the default for currency formatting is the larger of minimumFractionDigits and the number of minor unit digits provided by the ISO 4217 currency code list (2 if the list doesn't provide that information).
         */
        this.maxFractionDigits = null;
        /**
         *Mininum boundary value.
         */
        this.min = null;
        /**
         *Maximum boundary value.
         */
        this.max = null;
        /**
         *Step factor to increment/decrement the value.
         */
        this.step = 1;
        /**
         *Determines whether the input field is empty.
         */
        this.allowEmpty = true;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Style class of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Advisory information to display on input.
         */
        /*  public placeholder: string = null;*/ // this property is translated on multilingue
        /**
         *Size of the input field.
         */
        this.size = null;
        /**
         *Maximum number of character allows in the input field.
         */
        this.maxlength = null;
        /**
         *Specifies tab order of the element.
         */
        this.tabindex = null;
        /*
        /!**
         *When present, it specifies that the element should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         *When present, it specifies that an input field is read-only.
         */
        // public readonly: boolean = false; // CR: already in base field
        /**
         *Title text of the input text.
         */
        this.title = null;
        /**
         *Used to define a string that labels the input element.
         */
        this.ariaLabel = null;
        /**
         *Used to indicate that user input is required on an element before a form can be submitted.
         */
        this.ariaRequired = false;
        /**
         *Name of the input field.
         */
        // public name: string = null; // this property is translated on multilingue
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.autocomplete = null;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * directive
 */
export class PrgSetInputNumberConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input number configs and assign configs to element
     */
    set setInputNumberConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputNumberConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputNumberConfigsDirective, deps: [{ token: i1.InputNumber }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputNumberConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputNumberConfigsDirective, selector: "[setInputNumberConfigs]", inputs: { setInputNumberConfigs: "setInputNumberConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputNumberConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputNumberConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.InputNumber }]; }, propDecorators: { setInputNumberConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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