import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/inputnumber";
import * as i3 from "@angular/forms";
import * as i4 from "./input-number.model";
import * as i5 from "@ngx-translate/core";
/**
 * component input number
 */
export class PrgInputNumberComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgInputNumberComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputNumberComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgInputNumberComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputNumberComponent, selector: "prg-input-number-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\"  [formGroup]=\"form\">\r\n\r\n <p>{{\r\n   configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n   }}</p>\r\n\r\n  <p-inputNumber\r\n\r\n    [placeholder]=\"\r\nconfigs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n| translate\r\n\"\r\n    [setInputNumberConfigs]=\"configs\"\r\n    [inputId]=\"configs?.key\"\r\n    [formControlName]=\"configs?.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n\r\n    [name]=\"configs?.key + '.name' | translate\"\r\n(ngModelChange)=\"onChanged($event)\"\r\n\r\n  >\r\n  </p-inputNumber>\r\n</div\r\n>\r\n\r\n", dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.InputNumber, selector: "p-inputNumber", inputs: ["showButtons", "format", "buttonLayout", "inputId", "styleClass", "style", "placeholder", "size", "maxlength", "tabindex", "title", "ariaLabel", "ariaRequired", "name", "required", "autocomplete", "min", "max", "incrementButtonClass", "decrementButtonClass", "incrementButtonIcon", "decrementButtonIcon", "readonly", "step", "allowEmpty", "locale", "localeMatcher", "mode", "currency", "currencyDisplay", "useGrouping", "minFractionDigits", "maxFractionDigits", "prefix", "suffix", "inputStyle", "inputStyleClass", "showClear", "disabled"], outputs: ["onInput", "onFocus", "onBlur", "onKeyDown", "onClear"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetInputNumberConfigsDirective, selector: "[setInputNumberConfigs]", inputs: ["setInputNumberConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputNumberComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-number-field', template: "<div *ngIf=\"form\"  [formGroup]=\"form\">\r\n\r\n <p>{{\r\n   configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n   }}</p>\r\n\r\n  <p-inputNumber\r\n\r\n    [placeholder]=\"\r\nconfigs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n| translate\r\n\"\r\n    [setInputNumberConfigs]=\"configs\"\r\n    [inputId]=\"configs?.key\"\r\n    [formControlName]=\"configs?.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n\r\n    [name]=\"configs?.key + '.name' | translate\"\r\n(ngModelChange)=\"onChanged($event)\"\r\n\r\n  >\r\n  </p-inputNumber>\r\n</div\r\n>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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