import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/inputmask";
/**
 * Class Input Mask
 */
export class InputMaskConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputMask;
        /**
         *HTML5 input type
         */
        this.type = 'text';
        /**
         *Mask pattern.
         */
        this.mask = null;
        /**
         *Placeholder character in mask, default is underscore.
         */
        this.slotChar = '_';
        /**
         *Clears the incomplete value on blur.
         */
        this.autoClear = true;
        /**
         *Defines if ngModel sets the raw unmasked value to bound value or the formatted mask value.
         */
        this.unmask = false;
        /**
         *Inline style of the input field.
         */
        this.style = null;
        /**
         *Style class of the input field.
         */
        this.styleClass = null;
        /**
         *Advisory information to display on input.
         */
        this.placeholder = null;
        /**
         *Size of the input field.
         */
        this.size = null;
        /**
         *Maximum number of character allows in the input field.
         */
        this.maxlength = null;
        /**
         *Specifies tab order of the element.
         */
        this.tabindex = null;
        /**
         *Name of the input field.
         */
        this.name = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *When present, it specifies that an input field must be filled out before submitting the form.
         */
        this.required = false;
        /**
         *Regex pattern for alpha characters
         */
        this.characterPattern = '[a-Za-z]';
        /**
         *When present, the input gets a focus automatically on load.
         */
        this.autoFocus = false;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.autocomplete = null;
        /**
         *Used to define a string that labels the input element.
         */
        this.ariaLabel = null;
        /**
         *Used to indicate that user input is required on an element before a form can be submitted.
         */
        this.ariaRequired = false;
        /**
         *Title text of the input text.
         */
        this.title = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetInputMaskConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Input Mask configs and assign configs to element
     */
    set setInputMaskConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputMaskConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputMaskConfigsDirective, deps: [{ token: i1.InputMask }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputMaskConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputMaskConfigsDirective, selector: "[setInputMaskConfigs]", inputs: { setInputMaskConfigs: "setInputMaskConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputMaskConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputMaskConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.InputMask }]; }, propDecorators: { setInputMaskConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5wdXQtbWFzay5tb2RlbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy9jb3JlL2NvbXBvbmVudHMvZHluYW1pYy1mb3JtL2R5bmFtaWMtZm9ybS1maWVsZHMvZmllbGRzL2lucHV0LW1hc2svaW5wdXQtbWFzay5tb2RlbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUVqRCxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0sNEJBQTRCLENBQUM7QUFDdkQsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLHlDQUF5QyxDQUFDOzs7QUFFdEU7O0dBRUc7QUFDSCxNQUFNLE9BQU8sc0JBQXVCLFNBQVEsU0FBUztJQTJGbkQ7OztPQUdHO0lBQ0gsWUFBWSxJQUFzQztRQUNoRCxLQUFLLEVBQUUsQ0FBQztRQS9GVjs7V0FFRztRQUNJLGdCQUFXLEdBQVksV0FBVyxDQUFDLFNBQVMsQ0FBQztRQUVwRDs7V0FFRztRQUNJLFNBQUksR0FBVyxNQUFNLENBQUM7UUFDN0I7O1dBRUc7UUFDSSxTQUFJLEdBQVcsSUFBSSxDQUFDO1FBQzNCOztXQUVHO1FBQ0ksYUFBUSxHQUFXLEdBQUcsQ0FBQztRQUM5Qjs7V0FFRztRQUNJLGNBQVMsR0FBWSxJQUFJLENBQUM7UUFDakM7O1dBRUc7UUFDSSxXQUFNLEdBQVksS0FBSyxDQUFDO1FBQy9COztXQUVHO1FBQ0ksVUFBSyxHQUFXLElBQUksQ0FBQztRQUM1Qjs7V0FFRztRQUNJLGVBQVUsR0FBVyxJQUFJLENBQUM7UUFDakM7O1dBRUc7UUFDSSxnQkFBVyxHQUFXLElBQUksQ0FBQztRQUNsQzs7V0FFRztRQUNJLFNBQUksR0FBVyxJQUFJLENBQUM7UUFDM0I7O1dBRUc7UUFDSSxjQUFTLEdBQVcsSUFBSSxDQUFDO1FBQ2hDOztXQUVHO1FBQ0ksYUFBUSxHQUFXLElBQUksQ0FBQztRQUMvQjs7V0FFRztRQUNJLFNBQUksR0FBVyxJQUFJLENBQUM7UUFDM0I7O1dBRUc7UUFDSSxZQUFPLEdBQVcsSUFBSSxDQUFDO1FBQzlCOztXQUVHO1FBQ0ksYUFBUSxHQUFZLEtBQUssQ0FBQztRQUNqQzs7V0FFRztRQUNJLHFCQUFnQixHQUFXLFVBQVUsQ0FBQztRQUM3Qzs7V0FFRztRQUNJLGNBQVMsR0FBWSxLQUFLLENBQUM7UUFDbEM7O1dBRUc7UUFDSSxjQUFTLEdBQVksS0FBSyxDQUFDO1FBQ2xDOztXQUVHO1FBQ0ksaUJBQVksR0FBVyxJQUFJLENBQUM7UUFDbkM7O1dBRUc7UUFDSSxjQUFTLEdBQVcsSUFBSSxDQUFDO1FBQ2hDOztXQUVHO1FBQ0ksaUJBQVksR0FBWSxLQUFLLENBQUM7UUFDckM7O1dBRUc7UUFDSSxVQUFLLEdBQVcsSUFBSSxDQUFDO1FBUTFCLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQzVCLENBQUM7Q0FDRjtBQUVEOztHQUVHO0FBSUgsTUFBTSxPQUFPLCtCQUErQjtJQUMxQzs7O09BR0c7SUFDSCxZQUFvQixPQUFrQjtRQUFsQixZQUFPLEdBQVAsT0FBTyxDQUFXO0lBQUcsQ0FBQztJQUUxQzs7T0FFRztJQUNILElBQWEsbUJBQW1CLENBQUMsT0FBK0I7UUFDOUQsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ3ZDLENBQUM7OzRIQVpVLCtCQUErQjtnSEFBL0IsK0JBQStCOzJGQUEvQiwrQkFBK0I7a0JBSDNDLFNBQVM7bUJBQUM7b0JBQ1QsUUFBUSxFQUFFLHVCQUF1QjtpQkFDbEM7Z0dBV2MsbUJBQW1CO3NCQUEvQixLQUFLIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRGlyZWN0aXZlLCBJbnB1dCB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBJbnB1dE1hc2sgfSBmcm9tICdwcmltZW5nL2lucHV0bWFzayc7XHJcbmltcG9ydCB7IEJhc2VGaWVsZCB9IGZyb20gJy4uLy4uLy4uL21vZGVscy9iYXNlLWZpZWxkJztcclxuaW1wb3J0IHsgQ29udHJvbE5hbWUgfSBmcm9tICcuLi8uLi8uLi9tb2RlbHMvY29uc3RhbnRzL2NvbnRyb2wtbmFtZXMnO1xyXG5cclxuLyoqXHJcbiAqIENsYXNzIElucHV0IE1hc2tcclxuICovXHJcbmV4cG9ydCBjbGFzcyBJbnB1dE1hc2tDb25maWd1cmF0aW9uIGV4dGVuZHMgQmFzZUZpZWxkIHtcclxuICAvKipcclxuICAgKiBjb250cm9sIG5hbWVcclxuICAgKi9cclxuICBwdWJsaWMgY29udHJvbE5hbWU/OiBzdHJpbmcgPSBDb250cm9sTmFtZS5pbnB1dE1hc2s7XHJcblxyXG4gIC8qKlxyXG4gICAqSFRNTDUgaW5wdXQgdHlwZVxyXG4gICAqL1xyXG4gIHB1YmxpYyB0eXBlOiBzdHJpbmcgPSAndGV4dCc7XHJcbiAgLyoqXHJcbiAgICpNYXNrIHBhdHRlcm4uXHJcbiAgICovXHJcbiAgcHVibGljIG1hc2s6IHN0cmluZyA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpQbGFjZWhvbGRlciBjaGFyYWN0ZXIgaW4gbWFzaywgZGVmYXVsdCBpcyB1bmRlcnNjb3JlLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzbG90Q2hhcjogc3RyaW5nID0gJ18nO1xyXG4gIC8qKlxyXG4gICAqQ2xlYXJzIHRoZSBpbmNvbXBsZXRlIHZhbHVlIG9uIGJsdXIuXHJcbiAgICovXHJcbiAgcHVibGljIGF1dG9DbGVhcjogYm9vbGVhbiA9IHRydWU7XHJcbiAgLyoqXHJcbiAgICpEZWZpbmVzIGlmIG5nTW9kZWwgc2V0cyB0aGUgcmF3IHVubWFza2VkIHZhbHVlIHRvIGJvdW5kIHZhbHVlIG9yIHRoZSBmb3JtYXR0ZWQgbWFzayB2YWx1ZS5cclxuICAgKi9cclxuICBwdWJsaWMgdW5tYXNrOiBib29sZWFuID0gZmFsc2U7XHJcbiAgLyoqXHJcbiAgICpJbmxpbmUgc3R5bGUgb2YgdGhlIGlucHV0IGZpZWxkLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzdHlsZTogc3RyaW5nID0gbnVsbDtcclxuICAvKipcclxuICAgKlN0eWxlIGNsYXNzIG9mIHRoZSBpbnB1dCBmaWVsZC5cclxuICAgKi9cclxuICBwdWJsaWMgc3R5bGVDbGFzczogc3RyaW5nID0gbnVsbDtcclxuICAvKipcclxuICAgKkFkdmlzb3J5IGluZm9ybWF0aW9uIHRvIGRpc3BsYXkgb24gaW5wdXQuXHJcbiAgICovXHJcbiAgcHVibGljIHBsYWNlaG9sZGVyOiBzdHJpbmcgPSBudWxsO1xyXG4gIC8qKlxyXG4gICAqU2l6ZSBvZiB0aGUgaW5wdXQgZmllbGQuXHJcbiAgICovXHJcbiAgcHVibGljIHNpemU6IG51bWJlciA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpNYXhpbXVtIG51bWJlciBvZiBjaGFyYWN0ZXIgYWxsb3dzIGluIHRoZSBpbnB1dCBmaWVsZC5cclxuICAgKi9cclxuICBwdWJsaWMgbWF4bGVuZ3RoOiBudW1iZXIgPSBudWxsO1xyXG4gIC8qKlxyXG4gICAqU3BlY2lmaWVzIHRhYiBvcmRlciBvZiB0aGUgZWxlbWVudC5cclxuICAgKi9cclxuICBwdWJsaWMgdGFiaW5kZXg6IG51bWJlciA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpOYW1lIG9mIHRoZSBpbnB1dCBmaWVsZC5cclxuICAgKi9cclxuICBwdWJsaWMgbmFtZTogc3RyaW5nID0gbnVsbDtcclxuICAvKipcclxuICAgKklkZW50aWZpZXIgb2YgdGhlIGZvY3VzIGlucHV0IHRvIG1hdGNoIGEgbGFiZWwgZGVmaW5lZCBmb3IgdGhlIGNvbXBvbmVudC5cclxuICAgKi9cclxuICBwdWJsaWMgaW5wdXRJZDogc3RyaW5nID0gbnVsbDtcclxuICAvKipcclxuICAgKldoZW4gcHJlc2VudCwgaXQgc3BlY2lmaWVzIHRoYXQgYW4gaW5wdXQgZmllbGQgbXVzdCBiZSBmaWxsZWQgb3V0IGJlZm9yZSBzdWJtaXR0aW5nIHRoZSBmb3JtLlxyXG4gICAqL1xyXG4gIHB1YmxpYyByZXF1aXJlZDogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIC8qKlxyXG4gICAqUmVnZXggcGF0dGVybiBmb3IgYWxwaGEgY2hhcmFjdGVyc1xyXG4gICAqL1xyXG4gIHB1YmxpYyBjaGFyYWN0ZXJQYXR0ZXJuOiBzdHJpbmcgPSAnW2EtWmEtel0nO1xyXG4gIC8qKlxyXG4gICAqV2hlbiBwcmVzZW50LCB0aGUgaW5wdXQgZ2V0cyBhIGZvY3VzIGF1dG9tYXRpY2FsbHkgb24gbG9hZC5cclxuICAgKi9cclxuICBwdWJsaWMgYXV0b0ZvY3VzOiBib29sZWFuID0gZmFsc2U7XHJcbiAgLyoqXHJcbiAgICpXaGVuIGVuYWJsZWQsIGEgY2xlYXIgaWNvbiBpcyBkaXNwbGF5ZWQgdG8gY2xlYXIgdGhlIHZhbHVlLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzaG93Q2xlYXI6IGJvb2xlYW4gPSBmYWxzZTtcclxuICAvKipcclxuICAgKlVzZWQgdG8gZGVmaW5lIGEgc3RyaW5nIHRoYXQgYXV0b2NvbXBsZXRlIGF0dHJpYnV0ZSB0aGUgY3VycmVudCBlbGVtZW50LlxyXG4gICAqL1xyXG4gIHB1YmxpYyBhdXRvY29tcGxldGU6IHN0cmluZyA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpVc2VkIHRvIGRlZmluZSBhIHN0cmluZyB0aGF0IGxhYmVscyB0aGUgaW5wdXQgZWxlbWVudC5cclxuICAgKi9cclxuICBwdWJsaWMgYXJpYUxhYmVsOiBzdHJpbmcgPSBudWxsO1xyXG4gIC8qKlxyXG4gICAqVXNlZCB0byBpbmRpY2F0ZSB0aGF0IHVzZXIgaW5wdXQgaXMgcmVxdWlyZWQgb24gYW4gZWxlbWVudCBiZWZvcmUgYSBmb3JtIGNhbiBiZSBzdWJtaXR0ZWQuXHJcbiAgICovXHJcbiAgcHVibGljIGFyaWFSZXF1aXJlZDogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIC8qKlxyXG4gICAqVGl0bGUgdGV4dCBvZiB0aGUgaW5wdXQgdGV4dC5cclxuICAgKi9cclxuICBwdWJsaWMgdGl0bGU6IHN0cmluZyA9IG51bGw7XHJcblxyXG4gIC8qKlxyXG4gICAqIGNvbnN0cnVjdG9yXHJcbiAgICogQHBhcmFtIGluaXRcclxuICAgKi9cclxuICBjb25zdHJ1Y3Rvcihpbml0PzogUGFydGlhbDxJbnB1dE1hc2tDb25maWd1cmF0aW9uPikge1xyXG4gICAgc3VwZXIoKTtcclxuICAgIE9iamVjdC5hc3NpZ24odGhpcywgaW5pdCk7XHJcbiAgfVxyXG59XHJcblxyXG4vKipcclxuICogRGlyZWN0aXZlXHJcbiAqL1xyXG5ARGlyZWN0aXZlKHtcclxuICBzZWxlY3RvcjogJ1tzZXRJbnB1dE1hc2tDb25maWdzXScsXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBQcmdTZXRJbnB1dE1hc2tDb25maWdzRGlyZWN0aXZlIHtcclxuICAvKipcclxuICAgKiBjb25zdHJ1Y3RvclxyXG4gICAqIEBwYXJhbSBlbGVtZW50XHJcbiAgICovXHJcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBlbGVtZW50OiBJbnB1dE1hc2spIHt9XHJcblxyXG4gIC8qKlxyXG4gICAqIGlucHV0IElucHV0IE1hc2sgY29uZmlncyBhbmQgYXNzaWduIGNvbmZpZ3MgdG8gZWxlbWVudFxyXG4gICAqL1xyXG4gIEBJbnB1dCgpIHNldCBzZXRJbnB1dE1hc2tDb25maWdzKGNvbmZpZ3M6IElucHV0TWFza0NvbmZpZ3VyYXRpb24pIHtcclxuICAgIE9iamVjdC5hc3NpZ24odGhpcy5lbGVtZW50LCBjb25maWdzKTtcclxuICB9XHJcbn1cclxuIl19