import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/calendar";
/**
 * Class Input Text
 */
export class DateTimeConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputDateTime;
        /**
         *Set the date to highlight on first opening if the field is blank.
         */
        this.defaultDate = null;
        /**
         *Defines the quantity of the selection, valid values are single, multiple and range.
         */
        this.selectionMode = 'single';
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Style class of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Name of the input element.
         */
        // public name: string = null;
        /*
        /!**
         *When specified, disables the component.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         *Format of the date which can also be defined at locale settings.
         */
        this.dateFormat = 'mm/dd/yy';
        /**
         *When enabled, displays the calendar as inline. Default is false for popup mode.
         */
        this.inline = false;
        /**
         *Whether to display dates in other months (non-selectable) at the start or end of the current month. To make these days selectable use the selectOtherMonths option.
         */
        this.showOtherMonths = true;
        /**
         *Whether days in other months shown before or after the current month are selectable. This only applies if the showOtherMonths option is set to true.
         */
        this.selectOtherMonths = false;
        /**
         *When enabled, displays a button with icon next to input.
         */
        this.showIcon = false;
        /**
         *When disabled, datepicker will not be visible with input focus.
         */
        this.showOnFocus = true;
        /**
         *When enabled, calendar will show week numbers.
         */
        this.showWeek = false;
        /**
         *Icon of the calendar button.
         */
        this.icon = 'pi pi-calendar';
        /**
         *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *When specified, prevents entering the date manually with keyboard.
         */
        this.readonlyInput = null;
        /**
         *The cutoff year for determining the century for a date.
         */
        this.shortYearCutoff = '10';
        /**
         *The minimum selectable date.
         */
        this.minDate = null;
        /**
         *The maximum selectable date.
         */
        this.maxDate = null;
        /**
         *Array with dates that should be disabled (not selectable).
         */
        this.disabledDates = null;
        /**
         *Array with weekday numbers that should be disabled (not selectable).
         */
        this.disabledDays = null;
        /**
         *Whether the month should be rendered as a dropdown instead of text.
         */
        this.monthNavigator = false;
        /**
         *Whether the year should be rendered as a dropdown instead of text.
         */
        this.yearNavigator = false;
        /**
         *The range of years displayed in the year drop-down in (nnnn:nnnn) format such as (2000:2020).
         */
        this.yearRange = null;
        /**
         *Whether to display timepicker.
         */
        this.showTime = false;
        /**
         *Specifies 12 or 24 hour format.
         */
        this.hourFormat = '24';
        /**
         *Whether to display timepicker only.
         */
        this.timeOnly = false;
        /**
         *Separator of time selector.
         */
        this.timeSeparator = ':';
        /**
         *Type of the value to write back to ngModel, default is date and alternative is string.
         */
        this.dataType = 'date';
        /**
         *When present, it specifies that an input field must be filled out before submitting the form.
         */
        this.required = false;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Defines a string that labels the icon button for accessibility.
         */
        this.iconAriaLabel = null;
        /**
         *Whether to show the seconds in time picker.
         */
        this.showSeconds = false;
        /**
         *Hours to change per step.
         */
        this.stepHour = 1;
        /**
         *Minutes to change per step.
         */
        this.stepMinute = 1;
        /**
         *Seconds to change per step.
         */
        this.stepSecond = 1;
        /**
         *Maximum number of selectable dates in multiple mode.
         */
        this.maxDateCount = null;
        /**
         *Whether to display today and clear buttons at the footer
         */
        this.showButtonBar = false;
        /**
         *Style class of the today button.
         */
        this.todayButtonStyleClass = 'p-secondary-button';
        /**
         *Style class of the clear button.
         */
        this.clearButtonStyleClass = 'p-secondary-button';
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Style class of the datetimepicker container element.
         */
        this.panelStyleClass = null;
        /**
         *Inline style of the datetimepicker container element.
         */
        this.panelStyle = null;
        /**
         *Keep invalid value when input blur.
         */
        this.keepInvalid = false;
        /**
         *Whether to hide the overlay on date selection.
         */
        this.hideOnDateTimeSelect = true;
        /**
         *Number of months to display.
         */
        this.numberOfMonths = 1;
        //TODO: see this
        /**
         *Type of view to display, valid values are date for datepicker and month for month picker.
         */
        this.view = 'date';
        /**
         *Separator for multiple selection mode.
         */
        this.multipleSeparator = ',';
        /**
         *Separator for joining start and end dates on range selection mode.
         */
        this.rangeSeparator = '-';
        /**
         *When enabled, calendar overlay is displayed as optimized for touch devices.
         */
        this.touchUI = false;
        /**
         *When enabled, can only focus on elements inside the calendar.
         */
        this.focusTrap = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        /**
         *Defines the first of the week for various date calculations.
         */
        this.firstDayOfWeek = 0;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetDateTimeConfigsDirective {
    /**
     * constructor
     * @param cal
     */
    constructor(cal) {
        this.cal = cal;
    }
    /**
     * input data time configs and assign configs to element
     */
    set setDateTimeConfigs(configs) {
        Object.assign(this.cal, configs);
    }
}
PrgSetDateTimeConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetDateTimeConfigsDirective, deps: [{ token: i1.Calendar }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetDateTimeConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetDateTimeConfigsDirective, selector: "[setDateTimeConfigs]", inputs: { setDateTimeConfigs: "setDateTimeConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetDateTimeConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setDateTimeConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Calendar }]; }, propDecorators: { setDateTimeConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0ZS10aW1lLm1vZGVsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2NvcmUvY29tcG9uZW50cy9keW5hbWljLWZvcm0vZHluYW1pYy1mb3JtLWZpZWxkcy9maWVsZHMvaW5wdXQtZGF0ZS10aW1lL2RhdGUtdGltZS5tb2RlbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLEtBQUssRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUVqRCxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0sNEJBQTRCLENBQUM7QUFDdkQsT0FBTyxFQUFFLFdBQVcsRUFBRSxNQUFNLHlDQUF5QyxDQUFDOzs7QUFFdEU7O0dBRUc7QUFDSCxNQUFNLE9BQU8scUJBQXNCLFNBQVEsU0FBUztJQWtUbEQ7OztPQUdHO0lBQ0gsWUFBWSxJQUFxQztRQUMvQyxLQUFLLEVBQUUsQ0FBQztRQXRUVjs7V0FFRztRQUNJLGdCQUFXLEdBQVksV0FBVyxDQUFDLGFBQWEsQ0FBQztRQUN4RDs7V0FFRztRQUNJLGdCQUFXLEdBQVMsSUFBSSxDQUFDO1FBRWhDOztXQUVHO1FBQ0ksa0JBQWEsR0FBVyxRQUFRLENBQUM7UUFFeEM7O1dBRUc7UUFDSSxVQUFLLEdBQVcsSUFBSSxDQUFDO1FBRTVCOztXQUVHO1FBQ0ksZUFBVSxHQUFXLElBQUksQ0FBQztRQUVqQzs7V0FFRztRQUNJLGVBQVUsR0FBVyxJQUFJLENBQUM7UUFFakM7O1dBRUc7UUFDSSxvQkFBZSxHQUFXLElBQUksQ0FBQztRQUV0Qzs7V0FFRztRQUNJLFlBQU8sR0FBVyxJQUFJLENBQUM7UUFFOUI7O1dBRUc7UUFDSCw4QkFBOEI7UUFDOUI7Ozs7MkNBSW1DLENBQUMsZ0NBQWdDO1FBRXBFOztXQUVHO1FBQ0ksZUFBVSxHQUFXLFVBQVUsQ0FBQztRQUV2Qzs7V0FFRztRQUNJLFdBQU0sR0FBWSxLQUFLLENBQUM7UUFFL0I7O1dBRUc7UUFDSSxvQkFBZSxHQUFZLElBQUksQ0FBQztRQUV2Qzs7V0FFRztRQUNJLHNCQUFpQixHQUFZLEtBQUssQ0FBQztRQUUxQzs7V0FFRztRQUNJLGFBQVEsR0FBWSxLQUFLLENBQUM7UUFFakM7O1dBRUc7UUFDSSxnQkFBVyxHQUFZLElBQUksQ0FBQztRQUVuQzs7V0FFRztRQUNJLGFBQVEsR0FBWSxLQUFLLENBQUM7UUFFakM7O1dBRUc7UUFDSSxTQUFJLEdBQVcsZ0JBQWdCLENBQUM7UUFFdkM7O1dBRUc7UUFDSSxhQUFRLEdBQVEsSUFBSSxDQUFDO1FBRTVCOztXQUVHO1FBQ0ksa0JBQWEsR0FBWSxJQUFJLENBQUM7UUFFckM7O1dBRUc7UUFDSSxvQkFBZSxHQUFXLElBQUksQ0FBQztRQUV0Qzs7V0FFRztRQUNJLFlBQU8sR0FBUyxJQUFJLENBQUM7UUFFNUI7O1dBRUc7UUFDSSxZQUFPLEdBQVMsSUFBSSxDQUFDO1FBRTVCOztXQUVHO1FBQ0ksa0JBQWEsR0FBZ0IsSUFBSSxDQUFDO1FBRXpDOztXQUVHO1FBQ0ksaUJBQVksR0FBa0IsSUFBSSxDQUFDO1FBRTFDOztXQUVHO1FBQ0ksbUJBQWMsR0FBWSxLQUFLLENBQUM7UUFFdkM7O1dBRUc7UUFDSSxrQkFBYSxHQUFZLEtBQUssQ0FBQztRQUV0Qzs7V0FFRztRQUNJLGNBQVMsR0FBVyxJQUFJLENBQUM7UUFFaEM7O1dBRUc7UUFDSSxhQUFRLEdBQVksS0FBSyxDQUFDO1FBRWpDOztXQUVHO1FBQ0ksZUFBVSxHQUFXLElBQUksQ0FBQztRQUVqQzs7V0FFRztRQUNJLGFBQVEsR0FBWSxLQUFLLENBQUM7UUFFakM7O1dBRUc7UUFDSSxrQkFBYSxHQUFXLEdBQUcsQ0FBQztRQUVuQzs7V0FFRztRQUNJLGFBQVEsR0FBVyxNQUFNLENBQUM7UUFFakM7O1dBRUc7UUFDSSxhQUFRLEdBQVksS0FBSyxDQUFDO1FBRWpDOztXQUVHO1FBQ0ksYUFBUSxHQUFXLElBQUksQ0FBQztRQUUvQjs7V0FFRztRQUNJLG1CQUFjLEdBQVcsSUFBSSxDQUFDO1FBRXJDOztXQUVHO1FBQ0ksa0JBQWEsR0FBVyxJQUFJLENBQUM7UUFFcEM7O1dBRUc7UUFDSSxnQkFBVyxHQUFZLEtBQUssQ0FBQztRQUVwQzs7V0FFRztRQUNJLGFBQVEsR0FBVyxDQUFDLENBQUM7UUFFNUI7O1dBRUc7UUFDSSxlQUFVLEdBQVcsQ0FBQyxDQUFDO1FBRTlCOztXQUVHO1FBQ0ksZUFBVSxHQUFXLENBQUMsQ0FBQztRQUU5Qjs7V0FFRztRQUNJLGlCQUFZLEdBQVcsSUFBSSxDQUFDO1FBRW5DOztXQUVHO1FBQ0ksa0JBQWEsR0FBWSxLQUFLLENBQUM7UUFFdEM7O1dBRUc7UUFDSSwwQkFBcUIsR0FBVyxvQkFBb0IsQ0FBQztRQUU1RDs7V0FFRztRQUNJLDBCQUFxQixHQUFXLG9CQUFvQixDQUFDO1FBRTVEOztXQUVHO1FBQ0ksZUFBVSxHQUFXLENBQUMsQ0FBQztRQUU5Qjs7V0FFRztRQUNJLGVBQVUsR0FBWSxJQUFJLENBQUM7UUFFbEM7O1dBRUc7UUFDSSxvQkFBZSxHQUFXLElBQUksQ0FBQztRQUV0Qzs7V0FFRztRQUNJLGVBQVUsR0FBVyxJQUFJLENBQUM7UUFFakM7O1dBRUc7UUFDSSxnQkFBVyxHQUFZLEtBQUssQ0FBQztRQUVwQzs7V0FFRztRQUNJLHlCQUFvQixHQUFZLElBQUksQ0FBQztRQUU1Qzs7V0FFRztRQUNJLG1CQUFjLEdBQVcsQ0FBQyxDQUFDO1FBRWxDLGdCQUFnQjtRQUNoQjs7V0FFRztRQUNJLFNBQUksR0FBOEIsTUFBTSxDQUFDO1FBRWhEOztXQUVHO1FBQ0ksc0JBQWlCLEdBQVcsR0FBRyxDQUFDO1FBRXZDOztXQUVHO1FBQ0ksbUJBQWMsR0FBVyxHQUFHLENBQUM7UUFFcEM7O1dBRUc7UUFDSSxZQUFPLEdBQVksS0FBSyxDQUFDO1FBRWhDOztXQUVHO1FBQ0ksY0FBUyxHQUFZLElBQUksQ0FBQztRQUVqQzs7V0FFRztRQUNJLDBCQUFxQixHQUFXLGlDQUFpQyxDQUFDO1FBRXpFOztXQUVHO1FBQ0ksMEJBQXFCLEdBQVcsWUFBWSxDQUFDO1FBRXBEOztXQUVHO1FBQ0ksbUJBQWMsR0FBVyxDQUFDLENBQUM7UUFFbEM7O1dBRUc7UUFDSSxjQUFTLEdBQVksS0FBSyxDQUFDO1FBUWhDLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO0lBQzVCLENBQUM7Q0FDRjtBQUVEOztHQUVHO0FBSUgsTUFBTSxPQUFPLDhCQUE4QjtJQUN6Qzs7O09BR0c7SUFDSCxZQUFvQixHQUFhO1FBQWIsUUFBRyxHQUFILEdBQUcsQ0FBVTtJQUFHLENBQUM7SUFFckM7O09BRUc7SUFDSCxJQUFhLGtCQUFrQixDQUFDLE9BQW9DO1FBQ2xFLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxPQUFPLENBQUMsQ0FBQztJQUNuQyxDQUFDOzsySEFaVSw4QkFBOEI7K0dBQTlCLDhCQUE4QjsyRkFBOUIsOEJBQThCO2tCQUgxQyxTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSxzQkFBc0I7aUJBQ2pDOytGQVdjLGtCQUFrQjtzQkFBOUIsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERpcmVjdGl2ZSwgSW5wdXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgQ2FsZW5kYXIgfSBmcm9tICdwcmltZW5nL2NhbGVuZGFyJztcclxuaW1wb3J0IHsgQmFzZUZpZWxkIH0gZnJvbSAnLi4vLi4vLi4vbW9kZWxzL2Jhc2UtZmllbGQnO1xyXG5pbXBvcnQgeyBDb250cm9sTmFtZSB9IGZyb20gJy4uLy4uLy4uL21vZGVscy9jb25zdGFudHMvY29udHJvbC1uYW1lcyc7XHJcblxyXG4vKipcclxuICogQ2xhc3MgSW5wdXQgVGV4dFxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIERhdGVUaW1lQ29uZmlndXJhdGlvbiBleHRlbmRzIEJhc2VGaWVsZCB7XHJcbiAgLyoqXHJcbiAgICogY29udHJvbCBuYW1lXHJcbiAgICovXHJcbiAgcHVibGljIGNvbnRyb2xOYW1lPzogc3RyaW5nID0gQ29udHJvbE5hbWUuaW5wdXREYXRlVGltZTtcclxuICAvKipcclxuICAgKlNldCB0aGUgZGF0ZSB0byBoaWdobGlnaHQgb24gZmlyc3Qgb3BlbmluZyBpZiB0aGUgZmllbGQgaXMgYmxhbmsuXHJcbiAgICovXHJcbiAgcHVibGljIGRlZmF1bHREYXRlOiBEYXRlID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpEZWZpbmVzIHRoZSBxdWFudGl0eSBvZiB0aGUgc2VsZWN0aW9uLCB2YWxpZCB2YWx1ZXMgYXJlIHNpbmdsZSwgbXVsdGlwbGUgYW5kIHJhbmdlLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzZWxlY3Rpb25Nb2RlOiBzdHJpbmcgPSAnc2luZ2xlJztcclxuXHJcbiAgLyoqXHJcbiAgICpJbmxpbmUgc3R5bGUgb2YgdGhlIGNvbXBvbmVudC5cclxuICAgKi9cclxuICBwdWJsaWMgc3R5bGU6IHN0cmluZyA9IG51bGw7XHJcblxyXG4gIC8qKlxyXG4gICAqU3R5bGUgY2xhc3Mgb2YgdGhlIGNvbXBvbmVudC5cclxuICAgKi9cclxuICBwdWJsaWMgc3R5bGVDbGFzczogc3RyaW5nID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpJbmxpbmUgc3R5bGUgb2YgdGhlIGlucHV0IGZpZWxkLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBpbnB1dFN0eWxlOiBzdHJpbmcgPSBudWxsO1xyXG5cclxuICAvKipcclxuICAgKlN0eWxlIGNsYXNzIG9mIHRoZSBpbnB1dCBmaWVsZC5cclxuICAgKi9cclxuICBwdWJsaWMgaW5wdXRTdHlsZUNsYXNzOiBzdHJpbmcgPSBudWxsO1xyXG5cclxuICAvKipcclxuICAgKklkZW50aWZpZXIgb2YgdGhlIGZvY3VzIGlucHV0IHRvIG1hdGNoIGEgbGFiZWwgZGVmaW5lZCBmb3IgdGhlIGNvbXBvbmVudC5cclxuICAgKi9cclxuICBwdWJsaWMgaW5wdXRJZDogc3RyaW5nID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpOYW1lIG9mIHRoZSBpbnB1dCBlbGVtZW50LlxyXG4gICAqL1xyXG4gIC8vIHB1YmxpYyBuYW1lOiBzdHJpbmcgPSBudWxsO1xyXG4gIC8qXHJcbiAgLyEqKlxyXG4gICAqV2hlbiBzcGVjaWZpZWQsIGRpc2FibGVzIHRoZSBjb21wb25lbnQuXHJcbiAgICohL1xyXG4gIHB1YmxpYyBkaXNhYmxlZDogYm9vbGVhbiA9IGZhbHNlOyovIC8vUHJvcGVydHkgYWxyZWFkeSBvbiBCYXNlIEZpZWxkXHJcblxyXG4gIC8qKlxyXG4gICAqRm9ybWF0IG9mIHRoZSBkYXRlIHdoaWNoIGNhbiBhbHNvIGJlIGRlZmluZWQgYXQgbG9jYWxlIHNldHRpbmdzLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBkYXRlRm9ybWF0OiBzdHJpbmcgPSAnbW0vZGQveXknO1xyXG5cclxuICAvKipcclxuICAgKldoZW4gZW5hYmxlZCwgZGlzcGxheXMgdGhlIGNhbGVuZGFyIGFzIGlubGluZS4gRGVmYXVsdCBpcyBmYWxzZSBmb3IgcG9wdXAgbW9kZS5cclxuICAgKi9cclxuICBwdWJsaWMgaW5saW5lOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8qKlxyXG4gICAqV2hldGhlciB0byBkaXNwbGF5IGRhdGVzIGluIG90aGVyIG1vbnRocyAobm9uLXNlbGVjdGFibGUpIGF0IHRoZSBzdGFydCBvciBlbmQgb2YgdGhlIGN1cnJlbnQgbW9udGguIFRvIG1ha2UgdGhlc2UgZGF5cyBzZWxlY3RhYmxlIHVzZSB0aGUgc2VsZWN0T3RoZXJNb250aHMgb3B0aW9uLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzaG93T3RoZXJNb250aHM6IGJvb2xlYW4gPSB0cnVlO1xyXG5cclxuICAvKipcclxuICAgKldoZXRoZXIgZGF5cyBpbiBvdGhlciBtb250aHMgc2hvd24gYmVmb3JlIG9yIGFmdGVyIHRoZSBjdXJyZW50IG1vbnRoIGFyZSBzZWxlY3RhYmxlLiBUaGlzIG9ubHkgYXBwbGllcyBpZiB0aGUgc2hvd090aGVyTW9udGhzIG9wdGlvbiBpcyBzZXQgdG8gdHJ1ZS5cclxuICAgKi9cclxuICBwdWJsaWMgc2VsZWN0T3RoZXJNb250aHM6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgLyoqXHJcbiAgICpXaGVuIGVuYWJsZWQsIGRpc3BsYXlzIGEgYnV0dG9uIHdpdGggaWNvbiBuZXh0IHRvIGlucHV0LlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzaG93SWNvbjogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICAvKipcclxuICAgKldoZW4gZGlzYWJsZWQsIGRhdGVwaWNrZXIgd2lsbCBub3QgYmUgdmlzaWJsZSB3aXRoIGlucHV0IGZvY3VzLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzaG93T25Gb2N1czogYm9vbGVhbiA9IHRydWU7XHJcblxyXG4gIC8qKlxyXG4gICAqV2hlbiBlbmFibGVkLCBjYWxlbmRhciB3aWxsIHNob3cgd2VlayBudW1iZXJzLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzaG93V2VlazogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICAvKipcclxuICAgKkljb24gb2YgdGhlIGNhbGVuZGFyIGJ1dHRvbi5cclxuICAgKi9cclxuICBwdWJsaWMgaWNvbjogc3RyaW5nID0gJ3BpIHBpLWNhbGVuZGFyJztcclxuXHJcbiAgLyoqXHJcbiAgICpUYXJnZXQgZWxlbWVudCB0byBhdHRhY2ggdGhlIG92ZXJsYXksIHZhbGlkIHZhbHVlcyBhcmUgYm9keSBvciBhIGxvY2FsIG5nLXRlbXBsYXRlIHZhcmlhYmxlIG9mIGFub3RoZXIgZWxlbWVudCAobm90ZTogdXNlIGJpbmRpbmcgd2l0aCBicmFja2V0cyBmb3IgdGVtcGxhdGUgdmFyaWFibGVzLCBlLmcuIFthcHBlbmRUb109bXlkaXYgZm9yIGEgZGl2IGVsZW1lbnQgaGF2aW5nICNteWRpdiBhcyB2YXJpYWJsZSBuYW1lKS5cclxuICAgKi9cclxuICBwdWJsaWMgYXBwZW5kVG86IGFueSA9IG51bGw7XHJcblxyXG4gIC8qKlxyXG4gICAqV2hlbiBzcGVjaWZpZWQsIHByZXZlbnRzIGVudGVyaW5nIHRoZSBkYXRlIG1hbnVhbGx5IHdpdGgga2V5Ym9hcmQuXHJcbiAgICovXHJcbiAgcHVibGljIHJlYWRvbmx5SW5wdXQ6IGJvb2xlYW4gPSBudWxsO1xyXG5cclxuICAvKipcclxuICAgKlRoZSBjdXRvZmYgeWVhciBmb3IgZGV0ZXJtaW5pbmcgdGhlIGNlbnR1cnkgZm9yIGEgZGF0ZS5cclxuICAgKi9cclxuICBwdWJsaWMgc2hvcnRZZWFyQ3V0b2ZmOiBzdHJpbmcgPSAnMTAnO1xyXG5cclxuICAvKipcclxuICAgKlRoZSBtaW5pbXVtIHNlbGVjdGFibGUgZGF0ZS5cclxuICAgKi9cclxuICBwdWJsaWMgbWluRGF0ZTogRGF0ZSA9IG51bGw7XHJcblxyXG4gIC8qKlxyXG4gICAqVGhlIG1heGltdW0gc2VsZWN0YWJsZSBkYXRlLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBtYXhEYXRlOiBEYXRlID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpBcnJheSB3aXRoIGRhdGVzIHRoYXQgc2hvdWxkIGJlIGRpc2FibGVkIChub3Qgc2VsZWN0YWJsZSkuXHJcbiAgICovXHJcbiAgcHVibGljIGRpc2FibGVkRGF0ZXM6IEFycmF5PERhdGU+ID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpBcnJheSB3aXRoIHdlZWtkYXkgbnVtYmVycyB0aGF0IHNob3VsZCBiZSBkaXNhYmxlZCAobm90IHNlbGVjdGFibGUpLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBkaXNhYmxlZERheXM6IEFycmF5PG51bWJlcj4gPSBudWxsO1xyXG5cclxuICAvKipcclxuICAgKldoZXRoZXIgdGhlIG1vbnRoIHNob3VsZCBiZSByZW5kZXJlZCBhcyBhIGRyb3Bkb3duIGluc3RlYWQgb2YgdGV4dC5cclxuICAgKi9cclxuICBwdWJsaWMgbW9udGhOYXZpZ2F0b3I6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgLyoqXHJcbiAgICpXaGV0aGVyIHRoZSB5ZWFyIHNob3VsZCBiZSByZW5kZXJlZCBhcyBhIGRyb3Bkb3duIGluc3RlYWQgb2YgdGV4dC5cclxuICAgKi9cclxuICBwdWJsaWMgeWVhck5hdmlnYXRvcjogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICAvKipcclxuICAgKlRoZSByYW5nZSBvZiB5ZWFycyBkaXNwbGF5ZWQgaW4gdGhlIHllYXIgZHJvcC1kb3duIGluIChubm5uOm5ubm4pIGZvcm1hdCBzdWNoIGFzICgyMDAwOjIwMjApLlxyXG4gICAqL1xyXG4gIHB1YmxpYyB5ZWFyUmFuZ2U6IHN0cmluZyA9IG51bGw7XHJcblxyXG4gIC8qKlxyXG4gICAqV2hldGhlciB0byBkaXNwbGF5IHRpbWVwaWNrZXIuXHJcbiAgICovXHJcbiAgcHVibGljIHNob3dUaW1lOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8qKlxyXG4gICAqU3BlY2lmaWVzIDEyIG9yIDI0IGhvdXIgZm9ybWF0LlxyXG4gICAqL1xyXG4gIHB1YmxpYyBob3VyRm9ybWF0OiBzdHJpbmcgPSAnMjQnO1xyXG5cclxuICAvKipcclxuICAgKldoZXRoZXIgdG8gZGlzcGxheSB0aW1lcGlja2VyIG9ubHkuXHJcbiAgICovXHJcbiAgcHVibGljIHRpbWVPbmx5OiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8qKlxyXG4gICAqU2VwYXJhdG9yIG9mIHRpbWUgc2VsZWN0b3IuXHJcbiAgICovXHJcbiAgcHVibGljIHRpbWVTZXBhcmF0b3I6IHN0cmluZyA9ICc6JztcclxuXHJcbiAgLyoqXHJcbiAgICpUeXBlIG9mIHRoZSB2YWx1ZSB0byB3cml0ZSBiYWNrIHRvIG5nTW9kZWwsIGRlZmF1bHQgaXMgZGF0ZSBhbmQgYWx0ZXJuYXRpdmUgaXMgc3RyaW5nLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBkYXRhVHlwZTogc3RyaW5nID0gJ2RhdGUnO1xyXG5cclxuICAvKipcclxuICAgKldoZW4gcHJlc2VudCwgaXQgc3BlY2lmaWVzIHRoYXQgYW4gaW5wdXQgZmllbGQgbXVzdCBiZSBmaWxsZWQgb3V0IGJlZm9yZSBzdWJtaXR0aW5nIHRoZSBmb3JtLlxyXG4gICAqL1xyXG4gIHB1YmxpYyByZXF1aXJlZDogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICAvKipcclxuICAgKkluZGV4IG9mIHRoZSBlbGVtZW50IGluIHRhYmJpbmcgb3JkZXIuXHJcbiAgICovXHJcbiAgcHVibGljIHRhYmluZGV4OiBudW1iZXIgPSBudWxsO1xyXG5cclxuICAvKipcclxuICAgKkVzdGFibGlzaGVzIHJlbGF0aW9uc2hpcHMgYmV0d2VlbiB0aGUgY29tcG9uZW50IGFuZCBsYWJlbChzKSB3aGVyZSBpdHMgdmFsdWUgc2hvdWxkIGJlIG9uZSBvciBtb3JlIGVsZW1lbnQgSURzLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBhcmlhTGFiZWxsZWRCeTogc3RyaW5nID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpEZWZpbmVzIGEgc3RyaW5nIHRoYXQgbGFiZWxzIHRoZSBpY29uIGJ1dHRvbiBmb3IgYWNjZXNzaWJpbGl0eS5cclxuICAgKi9cclxuICBwdWJsaWMgaWNvbkFyaWFMYWJlbDogc3RyaW5nID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpXaGV0aGVyIHRvIHNob3cgdGhlIHNlY29uZHMgaW4gdGltZSBwaWNrZXIuXHJcbiAgICovXHJcbiAgcHVibGljIHNob3dTZWNvbmRzOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8qKlxyXG4gICAqSG91cnMgdG8gY2hhbmdlIHBlciBzdGVwLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzdGVwSG91cjogbnVtYmVyID0gMTtcclxuXHJcbiAgLyoqXHJcbiAgICpNaW51dGVzIHRvIGNoYW5nZSBwZXIgc3RlcC5cclxuICAgKi9cclxuICBwdWJsaWMgc3RlcE1pbnV0ZTogbnVtYmVyID0gMTtcclxuXHJcbiAgLyoqXHJcbiAgICpTZWNvbmRzIHRvIGNoYW5nZSBwZXIgc3RlcC5cclxuICAgKi9cclxuICBwdWJsaWMgc3RlcFNlY29uZDogbnVtYmVyID0gMTtcclxuXHJcbiAgLyoqXHJcbiAgICpNYXhpbXVtIG51bWJlciBvZiBzZWxlY3RhYmxlIGRhdGVzIGluIG11bHRpcGxlIG1vZGUuXHJcbiAgICovXHJcbiAgcHVibGljIG1heERhdGVDb3VudDogbnVtYmVyID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpXaGV0aGVyIHRvIGRpc3BsYXkgdG9kYXkgYW5kIGNsZWFyIGJ1dHRvbnMgYXQgdGhlIGZvb3RlclxyXG4gICAqL1xyXG4gIHB1YmxpYyBzaG93QnV0dG9uQmFyOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8qKlxyXG4gICAqU3R5bGUgY2xhc3Mgb2YgdGhlIHRvZGF5IGJ1dHRvbi5cclxuICAgKi9cclxuICBwdWJsaWMgdG9kYXlCdXR0b25TdHlsZUNsYXNzOiBzdHJpbmcgPSAncC1zZWNvbmRhcnktYnV0dG9uJztcclxuXHJcbiAgLyoqXHJcbiAgICpTdHlsZSBjbGFzcyBvZiB0aGUgY2xlYXIgYnV0dG9uLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBjbGVhckJ1dHRvblN0eWxlQ2xhc3M6IHN0cmluZyA9ICdwLXNlY29uZGFyeS1idXR0b24nO1xyXG5cclxuICAvKipcclxuICAgKkJhc2UgekluZGV4IHZhbHVlIHRvIHVzZSBpbiBsYXllcmluZy5cclxuICAgKi9cclxuICBwdWJsaWMgYmFzZVpJbmRleDogbnVtYmVyID0gMDtcclxuXHJcbiAgLyoqXHJcbiAgICpXaGV0aGVyIHRvIGF1dG9tYXRpY2FsbHkgbWFuYWdlIGxheWVyaW5nLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBhdXRvWkluZGV4OiBib29sZWFuID0gdHJ1ZTtcclxuXHJcbiAgLyoqXHJcbiAgICpTdHlsZSBjbGFzcyBvZiB0aGUgZGF0ZXRpbWVwaWNrZXIgY29udGFpbmVyIGVsZW1lbnQuXHJcbiAgICovXHJcbiAgcHVibGljIHBhbmVsU3R5bGVDbGFzczogc3RyaW5nID0gbnVsbDtcclxuXHJcbiAgLyoqXHJcbiAgICpJbmxpbmUgc3R5bGUgb2YgdGhlIGRhdGV0aW1lcGlja2VyIGNvbnRhaW5lciBlbGVtZW50LlxyXG4gICAqL1xyXG4gIHB1YmxpYyBwYW5lbFN0eWxlOiBvYmplY3QgPSBudWxsO1xyXG5cclxuICAvKipcclxuICAgKktlZXAgaW52YWxpZCB2YWx1ZSB3aGVuIGlucHV0IGJsdXIuXHJcbiAgICovXHJcbiAgcHVibGljIGtlZXBJbnZhbGlkOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8qKlxyXG4gICAqV2hldGhlciB0byBoaWRlIHRoZSBvdmVybGF5IG9uIGRhdGUgc2VsZWN0aW9uLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBoaWRlT25EYXRlVGltZVNlbGVjdDogYm9vbGVhbiA9IHRydWU7XHJcblxyXG4gIC8qKlxyXG4gICAqTnVtYmVyIG9mIG1vbnRocyB0byBkaXNwbGF5LlxyXG4gICAqL1xyXG4gIHB1YmxpYyBudW1iZXJPZk1vbnRoczogbnVtYmVyID0gMTtcclxuXHJcbiAgLy9UT0RPOiBzZWUgdGhpc1xyXG4gIC8qKlxyXG4gICAqVHlwZSBvZiB2aWV3IHRvIGRpc3BsYXksIHZhbGlkIHZhbHVlcyBhcmUgZGF0ZSBmb3IgZGF0ZXBpY2tlciBhbmQgbW9udGggZm9yIG1vbnRoIHBpY2tlci5cclxuICAgKi9cclxuICBwdWJsaWMgdmlldzogJ2RhdGUnIHwgJ21vbnRoJyB8ICd5ZWFyJyA9ICdkYXRlJztcclxuXHJcbiAgLyoqXHJcbiAgICpTZXBhcmF0b3IgZm9yIG11bHRpcGxlIHNlbGVjdGlvbiBtb2RlLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBtdWx0aXBsZVNlcGFyYXRvcjogc3RyaW5nID0gJywnO1xyXG5cclxuICAvKipcclxuICAgKlNlcGFyYXRvciBmb3Igam9pbmluZyBzdGFydCBhbmQgZW5kIGRhdGVzIG9uIHJhbmdlIHNlbGVjdGlvbiBtb2RlLlxyXG4gICAqL1xyXG4gIHB1YmxpYyByYW5nZVNlcGFyYXRvcjogc3RyaW5nID0gJy0nO1xyXG5cclxuICAvKipcclxuICAgKldoZW4gZW5hYmxlZCwgY2FsZW5kYXIgb3ZlcmxheSBpcyBkaXNwbGF5ZWQgYXMgb3B0aW1pemVkIGZvciB0b3VjaCBkZXZpY2VzLlxyXG4gICAqL1xyXG4gIHB1YmxpYyB0b3VjaFVJOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8qKlxyXG4gICAqV2hlbiBlbmFibGVkLCBjYW4gb25seSBmb2N1cyBvbiBlbGVtZW50cyBpbnNpZGUgdGhlIGNhbGVuZGFyLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBmb2N1c1RyYXA6IGJvb2xlYW4gPSB0cnVlO1xyXG5cclxuICAvKipcclxuICAgKlRyYW5zaXRpb24gb3B0aW9ucyBvZiB0aGUgc2hvdyBhbmltYXRpb24uXHJcbiAgICovXHJcbiAgcHVibGljIHNob3dUcmFuc2l0aW9uT3B0aW9uczogc3RyaW5nID0gJy4xMnMgY3ViaWMtYmV6aWVyKDAsIDAsIDAuMiwgMSknO1xyXG5cclxuICAvKipcclxuICAgKlRyYW5zaXRpb24gb3B0aW9ucyBvZiB0aGUgaGlkZSBhbmltYXRpb24uXHJcbiAgICovXHJcbiAgcHVibGljIGhpZGVUcmFuc2l0aW9uT3B0aW9uczogc3RyaW5nID0gJy4xcyBsaW5lYXInO1xyXG5cclxuICAvKipcclxuICAgKkRlZmluZXMgdGhlIGZpcnN0IG9mIHRoZSB3ZWVrIGZvciB2YXJpb3VzIGRhdGUgY2FsY3VsYXRpb25zLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBmaXJzdERheU9mV2VlazogbnVtYmVyID0gMDtcclxuXHJcbiAgLyoqXHJcbiAgICpXaGVuIGVuYWJsZWQsIGEgY2xlYXIgaWNvbiBpcyBkaXNwbGF5ZWQgdG8gY2xlYXIgdGhlIHZhbHVlLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBzaG93Q2xlYXI6IGJvb2xlYW4gPSBmYWxzZTtcclxuXHJcbiAgLyoqXHJcbiAgICogY29uc3RydWN0b3JcclxuICAgKiBAcGFyYW0gaW5pdFxyXG4gICAqL1xyXG4gIGNvbnN0cnVjdG9yKGluaXQ/OiBQYXJ0aWFsPERhdGVUaW1lQ29uZmlndXJhdGlvbj4pIHtcclxuICAgIHN1cGVyKCk7XHJcbiAgICBPYmplY3QuYXNzaWduKHRoaXMsIGluaXQpO1xyXG4gIH1cclxufVxyXG5cclxuLyoqXHJcbiAqIERpcmVjdGl2ZVxyXG4gKi9cclxuQERpcmVjdGl2ZSh7XHJcbiAgc2VsZWN0b3I6ICdbc2V0RGF0ZVRpbWVDb25maWdzXScsXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBQcmdTZXREYXRlVGltZUNvbmZpZ3NEaXJlY3RpdmUge1xyXG4gIC8qKlxyXG4gICAqIGNvbnN0cnVjdG9yXHJcbiAgICogQHBhcmFtIGNhbFxyXG4gICAqL1xyXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgY2FsOiBDYWxlbmRhcikge31cclxuXHJcbiAgLyoqXHJcbiAgICogaW5wdXQgZGF0YSB0aW1lIGNvbmZpZ3MgYW5kIGFzc2lnbiBjb25maWdzIHRvIGVsZW1lbnRcclxuICAgKi9cclxuICBASW5wdXQoKSBzZXQgc2V0RGF0ZVRpbWVDb25maWdzKGNvbmZpZ3M6IERhdGVUaW1lQ29uZmlndXJhdGlvbiB8IGFueSkge1xyXG4gICAgT2JqZWN0LmFzc2lnbih0aGlzLmNhbCwgY29uZmlncyk7XHJcbiAgfVxyXG59XHJcbiJdfQ==