import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/calendar";
import * as i3 from "@angular/forms";
import * as i4 from "./date-time.model";
import * as i5 from "@ngx-translate/core";
/**
 * component date time
 */
export class PrgDateTimeComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgDateTimeComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDateTimeComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgDateTimeComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDateTimeComponent, selector: "prg-date-time-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <p-calendar\r\n    [inputId]=\"configs.key\"\r\n    [setDateTimeConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n    [placeholder]=\"\r\n      configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n        | translate\r\n    \"\r\n    (ngModelChange)=\"onChanged($event)\"\r\n  >\r\n  </p-calendar>\r\n\r\n  <label for=\"{{ configs.key }}\"\r\n    >{{\r\n      configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n    }}\r\n  </label>\r\n</span>\r\n", dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.Calendar, selector: "p-calendar", inputs: ["style", "styleClass", "inputStyle", "inputId", "name", "inputStyleClass", "placeholder", "ariaLabelledBy", "iconAriaLabel", "disabled", "dateFormat", "multipleSeparator", "rangeSeparator", "inline", "showOtherMonths", "selectOtherMonths", "showIcon", "icon", "appendTo", "readonlyInput", "shortYearCutoff", "monthNavigator", "yearNavigator", "hourFormat", "timeOnly", "stepHour", "stepMinute", "stepSecond", "showSeconds", "required", "showOnFocus", "showWeek", "showClear", "dataType", "selectionMode", "maxDateCount", "showButtonBar", "todayButtonStyleClass", "clearButtonStyleClass", "autoZIndex", "baseZIndex", "panelStyleClass", "panelStyle", "keepInvalid", "hideOnDateTimeSelect", "touchUI", "timeSeparator", "focusTrap", "showTransitionOptions", "hideTransitionOptions", "tabindex", "view", "defaultDate", "minDate", "maxDate", "disabledDates", "disabledDays", "yearRange", "showTime", "responsiveOptions", "numberOfMonths", "firstDayOfWeek", "locale"], outputs: ["onFocus", "onBlur", "onClose", "onSelect", "onClear", "onInput", "onTodayClick", "onClearClick", "onMonthChange", "onYearChange", "onClickOutside", "onShow"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetDateTimeConfigsDirective, selector: "[setDateTimeConfigs]", inputs: ["setDateTimeConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDateTimeComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-date-time-field', template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <p-calendar\r\n    [inputId]=\"configs.key\"\r\n    [setDateTimeConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n    [placeholder]=\"\r\n      configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n        | translate\r\n    \"\r\n    (ngModelChange)=\"onChanged($event)\"\r\n  >\r\n  </p-calendar>\r\n\r\n  <label for=\"{{ configs.key }}\"\r\n    >{{\r\n      configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n    }}\r\n  </label>\r\n</span>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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