import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/colorpicker";
/**
 * Class Color Picker
 */
export class ColorPickerConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.colorPicker;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Whether to display as an overlay or not.
         */
        this.inline = false;
        /**
         *Format to use in value binding, supported formats are "hex", "rgb" and "hsb".
         */
        this.format = 'hex';
        /**
         *Target element to attach the overlay, valid values are "body" or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]="mydiv" for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the dropdown.
         */
        this.inputId = null;
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetColorPickerConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Color Picker configs and assign configs to element
     */
    set setColorPickerConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetColorPickerConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetColorPickerConfigsDirective, deps: [{ token: i1.ColorPicker }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetColorPickerConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetColorPickerConfigsDirective, selector: "[setColorPickerConfigs]", inputs: { setColorPickerConfigs: "setColorPickerConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetColorPickerConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setColorPickerConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.ColorPicker }]; }, propDecorators: { setColorPickerConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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