import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/chips";
/**
 * Class Chips
 */
export class ChipsConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.chips;
        /**
         *Name of the property to display on a chip.
         */
        this.field = null;
        /**
         *Maximum number of entries allowed.
         */
        this.max = null;
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Advisory information to display on input.
         */
        this.placeholder = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Whether to allow duplicate values or not.
         */
        this.allowDuplicate = true;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Style class of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Whether to add an item on tab key press.
         */
        this.addOnTab = false;
        /**
         *Whether to add an item when the input loses focus.
         */
        this.addOnBlur = false;
        /**
         *Separator char to add an item when pressed in addition to the enter key. Currently only possible value is ","
         */
        this.separator = ',';
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetChipsConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Chips configs and assign configs to element
     */
    set setChipsConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetChipsConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetChipsConfigsDirective, deps: [{ token: i1.Chips }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetChipsConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetChipsConfigsDirective, selector: "[setChipsConfigs]", inputs: { setChipsConfigs: "setChipsConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetChipsConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setChipsConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Chips }]; }, propDecorators: { setChipsConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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