import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "primeng/chips";
import * as i2 from "@angular/common";
import * as i3 from "@angular/forms";
import * as i4 from "./chips.model";
import * as i5 from "@ngx-translate/core";
/**
 * Component Rating
 */
export class PrgChipsComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgChipsComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgChipsComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgChipsComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgChipsComponent, selector: "prg-chips-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<span *ngIf=\"form\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n  <p-chips\r\n    [setChipsConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs?.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    (onAdd)=\"onChanged($event)\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n  ></p-chips>\r\n      <label for=\"{{configs.key}}\">{{\r\n        configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n        }}</label>\r\n\r\n  </span>\r\n</span>\r\n", dependencies: [{ kind: "component", type: i1.Chips, selector: "p-chips", inputs: ["style", "styleClass", "disabled", "field", "placeholder", "max", "ariaLabelledBy", "tabindex", "inputId", "allowDuplicate", "inputStyle", "inputStyleClass", "addOnTab", "addOnBlur", "separator", "showClear"], outputs: ["onAdd", "onRemove", "onFocus", "onBlur", "onChipClick", "onClear"] }, { kind: "directive", type: i2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetChipsConfigsDirective, selector: "[setChipsConfigs]", inputs: ["setChipsConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgChipsComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-chips-field', template: "<span *ngIf=\"form\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n  <p-chips\r\n    [setChipsConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs?.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    (onAdd)=\"onChanged($event)\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n  ></p-chips>\r\n      <label for=\"{{configs.key}}\">{{\r\n        configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n        }}</label>\r\n\r\n  </span>\r\n</span>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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