import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/checkbox";
/**
 * Class CheckBox
 */
export class CheckboxConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.checkbox;
        /**
         *Name of the checkbox group.
         */
        this.name = null;
        /*  /!**
         *Value of the checkbox.
         *!/
        public value: any = null;*/ //Property already on Base Field
        /**
         *Label of the checkbox.
         */
        this.label = null;
        /*
        /!**
         *When present, it specifies that the element should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         *Allows to select a boolean value instead of multiple values.
         */
        this.binary = true;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Used to define a string that labels the input element.
         */
        this.ariaLabel = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Style class of the label.
         */
        this.labelStyleClass = null;
        /**
         *Icon class of the checkbox icon.
         */
        this.checkboxIcon = 'pi pi-check';
        /*  /!**
         *When present, it specifies that the component cannot be edited.
         *!/
        public readonly: boolean = false;*/ //Property already on Base Field
        /**
         *When present, it specifies that checkbox must be checked before submitting the form.
         */
        this.required = false;
        /**
         *An array of objects to display as dynamic values.Mandatory field.
         */
        this.options = null;
        /**
         *Name of the value field of an option. Default 'value'.
         */
        this.optionValue = 'value';
        /**
         *Name of the key field of an option.Default 'key'.Also used to bring the translation of the field
         */
        this.optionKey = 'key';
        /**
         * Allow multiple checkbox selection. On false , whenever a checkbox is checked the others became disabled.
         */
        this.allowMultipleCheckBoxSelection = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetCheckboxConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input checkbox configs and assign configs to element
     */
    set setCheckboxConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetCheckboxConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetCheckboxConfigsDirective, deps: [{ token: i1.Checkbox }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetCheckboxConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetCheckboxConfigsDirective, selector: "[setCheckboxConfigs]", inputs: { setCheckboxConfigs: "setCheckboxConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetCheckboxConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setCheckboxConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Checkbox }]; }, propDecorators: { setCheckboxConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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