import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/checkbox";
import * as i3 from "@angular/forms";
import * as i4 from "./checkbox.model";
import * as i5 from "@ngx-translate/core";
/**
 * Checkbox Component
 */
export class PrgCheckboxComponent {
    constructor() {
        /**
         * Property binding of checkbox values (multiple checkboxes)
         * @type {any}
         */
        this.valueChecked = [];
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.checked,
                event: event,
            }));
        }
    }
}
PrgCheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCheckboxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgCheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgCheckboxComponent, selector: "prg-checkbox-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<ng-container *ngIf=\"configs.options;else singleCheckbox\">\r\n  <div *ngIf=\"form\" [formGroup]=\"form\">\r\n    <div *ngFor=\"let option of configs.options; let i=index\" class=\"field-checkbox\">\r\n      <p-checkbox\r\n                  [formControlName]=\"configs.key\"\r\n                  (onChange)=\"onChanged($event)\"\r\n                  [setCheckboxConfigs]=\"configs\"\r\n                  [inputId]=\"option[configs.optionKey]\"\r\n                  [value]=\"option[configs.optionValue]\"\r\n                  [binary]=\"false\"\r\n                  [name]=\"option[configs.optionKey]\"\r\n                  [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n                  [(ngModel)]=\"valueChecked\"\r\n                  [disabled]=\"configs.disabled||(!configs.allowMultipleCheckBoxSelection&&valueChecked?.length>0&&valueChecked!=option[configs.optionValue])\"\r\n      >\r\n      </p-checkbox>\r\n      <label\r\n        for=\"{{option[configs.optionKey]}}\">{{configs.basePathTranslation + '.' + configs.key + '.' + option[configs.optionKey] + '.label' | translate}}</label>\r\n    </div>\r\n  </div>\r\n</ng-container>\r\n<ng-template #singleCheckbox>\r\n  <div class=\"field-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n    <p-checkbox\r\n      (onChange)=\"onChanged($event)\"\r\n      [setCheckboxConfigs]=\"configs\"\r\n      [formControlName]=\"configs.key\"\r\n      [inputId]=\"configs.key\"\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [name]=\"configs.key + '.name' | translate\"></p-checkbox>\r\n    <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n  </div>\r\n</ng-template>\r\n", dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.Checkbox, selector: "p-checkbox", inputs: ["value", "name", "disabled", "binary", "label", "ariaLabelledBy", "ariaLabel", "tabindex", "inputId", "style", "styleClass", "labelStyleClass", "formControl", "checkboxIcon", "readonly", "required", "trueValue", "falseValue"], outputs: ["onChange"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetCheckboxConfigsDirective, selector: "[setCheckboxConfigs]", inputs: ["setCheckboxConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCheckboxComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-checkbox-field', template: "<ng-container *ngIf=\"configs.options;else singleCheckbox\">\r\n  <div *ngIf=\"form\" [formGroup]=\"form\">\r\n    <div *ngFor=\"let option of configs.options; let i=index\" class=\"field-checkbox\">\r\n      <p-checkbox\r\n                  [formControlName]=\"configs.key\"\r\n                  (onChange)=\"onChanged($event)\"\r\n                  [setCheckboxConfigs]=\"configs\"\r\n                  [inputId]=\"option[configs.optionKey]\"\r\n                  [value]=\"option[configs.optionValue]\"\r\n                  [binary]=\"false\"\r\n                  [name]=\"option[configs.optionKey]\"\r\n                  [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n                  [(ngModel)]=\"valueChecked\"\r\n                  [disabled]=\"configs.disabled||(!configs.allowMultipleCheckBoxSelection&&valueChecked?.length>0&&valueChecked!=option[configs.optionValue])\"\r\n      >\r\n      </p-checkbox>\r\n      <label\r\n        for=\"{{option[configs.optionKey]}}\">{{configs.basePathTranslation + '.' + configs.key + '.' + option[configs.optionKey] + '.label' | translate}}</label>\r\n    </div>\r\n  </div>\r\n</ng-container>\r\n<ng-template #singleCheckbox>\r\n  <div class=\"field-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n    <p-checkbox\r\n      (onChange)=\"onChanged($event)\"\r\n      [setCheckboxConfigs]=\"configs\"\r\n      [formControlName]=\"configs.key\"\r\n      [inputId]=\"configs.key\"\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [name]=\"configs.key + '.name' | translate\"></p-checkbox>\r\n    <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n  </div>\r\n</ng-template>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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