import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/cascadeselect";
/**
 * Class Cascade Select
 */
export class CascadeSelectConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.cascadeSelect;
        /**
         *An array of selectitems to display as the available options.
         */
        this.options = null;
        /**
         *Property name or getter function to use as the label of an option.
         */
        this.optionLabel = null;
        /**
         *Property name or getter function to use as the value of an option, defaults to the option itself when not defined.
         */
        this.optionValue = null;
        /**
         *Property name or getter function to use as the label of an option group.
         */
        this.optionGroupLabel = null;
        /**
         *Property name or getter function to retrieve the items of a group.
         */
        this.optionGroupChildren = null;
        /**
         *Default text to display when no option is selected.
         */
        this.placeholder = null;
        /**
         *When present, it specifies that the component should be disabled.
         */
        this.disabled = false;
        /**
         *A property to uniquely identify an option.
         */
        this.dataKey = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the underlying input element.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Id of the element or "body" for document where the overlay should be appended to.
         */
        this.appendTo = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Inline style of the overlay panel.
         */
        this.panelStyle = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Style class of the overlay panel.
         */
        this.panelStyleClass = null;
        /**
         *Label of the input for accessibility.
         */
        this.inputLabel = null;
        /**
         *Defines a string that labels the input for accessibility.
         */
        this.ariaLabel = null;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetCascadeSelectConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Cascade Selected configs and assign configs to element
     */
    set setCascadeSelectConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetCascadeSelectConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetCascadeSelectConfigsDirective, deps: [{ token: i1.CascadeSelect }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetCascadeSelectConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetCascadeSelectConfigsDirective, selector: "[setCascadeSelectConfigs]", inputs: { setCascadeSelectConfigs: "setCascadeSelectConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetCascadeSelectConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setCascadeSelectConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.CascadeSelect }]; }, propDecorators: { setCascadeSelectConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FzY2FkZS1zZWxlY3QuLm1vZGVsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2NvcmUvY29tcG9uZW50cy9keW5hbWljLWZvcm0vZHluYW1pYy1mb3JtLWZpZWxkcy9maWVsZHMvY2FzY2FkZS1zZWxlY3QvY2FzY2FkZS1zZWxlY3QuLm1vZGVsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBRWpELE9BQU8sRUFBRSxTQUFTLEVBQUUsTUFBTSw0QkFBNEIsQ0FBQztBQUN2RCxPQUFPLEVBQUUsV0FBVyxFQUFFLE1BQU0seUNBQXlDLENBQUM7OztBQUV0RTs7R0FFRztBQUNILE1BQU0sT0FBTywwQkFBMkIsU0FBUSxTQUFTO0lBa0Z2RDs7O09BR0c7SUFDSCxZQUFZLElBQTBDO1FBQ3BELEtBQUssRUFBRSxDQUFDO1FBdEZWOztXQUVHO1FBQ0ksZ0JBQVcsR0FBVyxXQUFXLENBQUMsYUFBYSxDQUFDO1FBQ3ZEOztXQUVHO1FBQ0ksWUFBTyxHQUFVLElBQUksQ0FBQztRQUM3Qjs7V0FFRztRQUNJLGdCQUFXLEdBQVcsSUFBSSxDQUFDO1FBQ2xDOztXQUVHO1FBQ0ksZ0JBQVcsR0FBVyxJQUFJLENBQUM7UUFDbEM7O1dBRUc7UUFDSSxxQkFBZ0IsR0FBVyxJQUFJLENBQUM7UUFDdkM7O1dBRUc7UUFDSSx3QkFBbUIsR0FBVSxJQUFJLENBQUM7UUFDekM7O1dBRUc7UUFDSSxnQkFBVyxHQUFXLElBQUksQ0FBQztRQUNsQzs7V0FFRztRQUNJLGFBQVEsR0FBWSxLQUFLLENBQUM7UUFDakM7O1dBRUc7UUFDSSxZQUFPLEdBQVcsSUFBSSxDQUFDO1FBQzlCOztXQUVHO1FBQ0ksYUFBUSxHQUFXLElBQUksQ0FBQztRQUMvQjs7V0FFRztRQUNJLFlBQU8sR0FBVyxJQUFJLENBQUM7UUFDOUI7O1dBRUc7UUFDSSxtQkFBYyxHQUFXLElBQUksQ0FBQztRQUNyQzs7V0FFRztRQUNJLGFBQVEsR0FBVyxJQUFJLENBQUM7UUFDL0I7O1dBRUc7UUFDSSxVQUFLLEdBQVcsSUFBSSxDQUFDO1FBQzVCOztXQUVHO1FBQ0ksZUFBVSxHQUFXLElBQUksQ0FBQztRQUNqQzs7V0FFRztRQUNJLGVBQVUsR0FBVyxJQUFJLENBQUM7UUFDakM7O1dBRUc7UUFDSSxvQkFBZSxHQUFXLElBQUksQ0FBQztRQUN0Qzs7V0FFRztRQUNJLGVBQVUsR0FBVyxJQUFJLENBQUM7UUFDakM7O1dBRUc7UUFDSSxjQUFTLEdBQVcsSUFBSSxDQUFDO1FBQ2hDOztXQUVHO1FBQ0ksY0FBUyxHQUFZLEtBQUssQ0FBQztRQVFoQyxNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQztJQUM1QixDQUFDO0NBQ0Y7QUFFRDs7R0FFRztBQUlILE1BQU0sT0FBTyxtQ0FBbUM7SUFDOUM7OztPQUdHO0lBQ0gsWUFBb0IsT0FBc0I7UUFBdEIsWUFBTyxHQUFQLE9BQU8sQ0FBZTtJQUFHLENBQUM7SUFFOUM7O09BRUc7SUFDSCxJQUFhLHVCQUF1QixDQUFDLE9BQW1DO1FBQ3RFLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxPQUFPLENBQUMsQ0FBQztJQUN2QyxDQUFDOztnSUFaVSxtQ0FBbUM7b0hBQW5DLG1DQUFtQzsyRkFBbkMsbUNBQW1DO2tCQUgvQyxTQUFTO21CQUFDO29CQUNULFFBQVEsRUFBRSwyQkFBMkI7aUJBQ3RDO29HQVdjLHVCQUF1QjtzQkFBbkMsS0FBSyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IERpcmVjdGl2ZSwgSW5wdXQgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgQ2FzY2FkZVNlbGVjdCB9IGZyb20gJ3ByaW1lbmcvY2FzY2FkZXNlbGVjdCc7XHJcbmltcG9ydCB7IEJhc2VGaWVsZCB9IGZyb20gJy4uLy4uLy4uL21vZGVscy9iYXNlLWZpZWxkJztcclxuaW1wb3J0IHsgQ29udHJvbE5hbWUgfSBmcm9tICcuLi8uLi8uLi9tb2RlbHMvY29uc3RhbnRzL2NvbnRyb2wtbmFtZXMnO1xyXG5cclxuLyoqXHJcbiAqIENsYXNzIENhc2NhZGUgU2VsZWN0XHJcbiAqL1xyXG5leHBvcnQgY2xhc3MgQ2FzY2FkZVNlbGVjdENvbmZpZ3VyYXRpb24gZXh0ZW5kcyBCYXNlRmllbGQge1xyXG4gIC8qKlxyXG4gICAqIGNvbnRyb2wgbmFtZVxyXG4gICAqL1xyXG4gIHB1YmxpYyBjb250cm9sTmFtZTogc3RyaW5nID0gQ29udHJvbE5hbWUuY2FzY2FkZVNlbGVjdDtcclxuICAvKipcclxuICAgKkFuIGFycmF5IG9mIHNlbGVjdGl0ZW1zIHRvIGRpc3BsYXkgYXMgdGhlIGF2YWlsYWJsZSBvcHRpb25zLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBvcHRpb25zOiBhbnlbXSA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpQcm9wZXJ0eSBuYW1lIG9yIGdldHRlciBmdW5jdGlvbiB0byB1c2UgYXMgdGhlIGxhYmVsIG9mIGFuIG9wdGlvbi5cclxuICAgKi9cclxuICBwdWJsaWMgb3B0aW9uTGFiZWw6IHN0cmluZyA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpQcm9wZXJ0eSBuYW1lIG9yIGdldHRlciBmdW5jdGlvbiB0byB1c2UgYXMgdGhlIHZhbHVlIG9mIGFuIG9wdGlvbiwgZGVmYXVsdHMgdG8gdGhlIG9wdGlvbiBpdHNlbGYgd2hlbiBub3QgZGVmaW5lZC5cclxuICAgKi9cclxuICBwdWJsaWMgb3B0aW9uVmFsdWU6IHN0cmluZyA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpQcm9wZXJ0eSBuYW1lIG9yIGdldHRlciBmdW5jdGlvbiB0byB1c2UgYXMgdGhlIGxhYmVsIG9mIGFuIG9wdGlvbiBncm91cC5cclxuICAgKi9cclxuICBwdWJsaWMgb3B0aW9uR3JvdXBMYWJlbDogc3RyaW5nID0gbnVsbDtcclxuICAvKipcclxuICAgKlByb3BlcnR5IG5hbWUgb3IgZ2V0dGVyIGZ1bmN0aW9uIHRvIHJldHJpZXZlIHRoZSBpdGVtcyBvZiBhIGdyb3VwLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBvcHRpb25Hcm91cENoaWxkcmVuOiBhbnlbXSA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpEZWZhdWx0IHRleHQgdG8gZGlzcGxheSB3aGVuIG5vIG9wdGlvbiBpcyBzZWxlY3RlZC5cclxuICAgKi9cclxuICBwdWJsaWMgcGxhY2Vob2xkZXI6IHN0cmluZyA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpXaGVuIHByZXNlbnQsIGl0IHNwZWNpZmllcyB0aGF0IHRoZSBjb21wb25lbnQgc2hvdWxkIGJlIGRpc2FibGVkLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBkaXNhYmxlZDogYm9vbGVhbiA9IGZhbHNlO1xyXG4gIC8qKlxyXG4gICAqQSBwcm9wZXJ0eSB0byB1bmlxdWVseSBpZGVudGlmeSBhbiBvcHRpb24uXHJcbiAgICovXHJcbiAgcHVibGljIGRhdGFLZXk6IHN0cmluZyA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpJbmRleCBvZiB0aGUgZWxlbWVudCBpbiB0YWJiaW5nIG9yZGVyLlxyXG4gICAqL1xyXG4gIHB1YmxpYyB0YWJpbmRleDogbnVtYmVyID0gbnVsbDtcclxuICAvKipcclxuICAgKklkZW50aWZpZXIgb2YgdGhlIHVuZGVybHlpbmcgaW5wdXQgZWxlbWVudC5cclxuICAgKi9cclxuICBwdWJsaWMgaW5wdXRJZDogc3RyaW5nID0gbnVsbDtcclxuICAvKipcclxuICAgKkVzdGFibGlzaGVzIHJlbGF0aW9uc2hpcHMgYmV0d2VlbiB0aGUgY29tcG9uZW50IGFuZCBsYWJlbChzKSB3aGVyZSBpdHMgdmFsdWUgc2hvdWxkIGJlIG9uZSBvciBtb3JlIGVsZW1lbnQgSURzLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBhcmlhTGFiZWxsZWRCeTogc3RyaW5nID0gbnVsbDtcclxuICAvKipcclxuICAgKklkIG9mIHRoZSBlbGVtZW50IG9yIFwiYm9keVwiIGZvciBkb2N1bWVudCB3aGVyZSB0aGUgb3ZlcmxheSBzaG91bGQgYmUgYXBwZW5kZWQgdG8uXHJcbiAgICovXHJcbiAgcHVibGljIGFwcGVuZFRvOiBzdHJpbmcgPSBudWxsO1xyXG4gIC8qKlxyXG4gICAqSW5saW5lIHN0eWxlIG9mIHRoZSBjb21wb25lbnQuXHJcbiAgICovXHJcbiAgcHVibGljIHN0eWxlOiBvYmplY3QgPSBudWxsO1xyXG4gIC8qKlxyXG4gICAqSW5saW5lIHN0eWxlIG9mIHRoZSBvdmVybGF5IHBhbmVsLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBwYW5lbFN0eWxlOiBvYmplY3QgPSBudWxsO1xyXG4gIC8qKlxyXG4gICAqU3R5bGUgY2xhc3Mgb2YgdGhlIGNvbXBvbmVudC5cclxuICAgKi9cclxuICBwdWJsaWMgc3R5bGVDbGFzczogc3RyaW5nID0gbnVsbDtcclxuICAvKipcclxuICAgKlN0eWxlIGNsYXNzIG9mIHRoZSBvdmVybGF5IHBhbmVsLlxyXG4gICAqL1xyXG4gIHB1YmxpYyBwYW5lbFN0eWxlQ2xhc3M6IHN0cmluZyA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpMYWJlbCBvZiB0aGUgaW5wdXQgZm9yIGFjY2Vzc2liaWxpdHkuXHJcbiAgICovXHJcbiAgcHVibGljIGlucHV0TGFiZWw6IHN0cmluZyA9IG51bGw7XHJcbiAgLyoqXHJcbiAgICpEZWZpbmVzIGEgc3RyaW5nIHRoYXQgbGFiZWxzIHRoZSBpbnB1dCBmb3IgYWNjZXNzaWJpbGl0eS5cclxuICAgKi9cclxuICBwdWJsaWMgYXJpYUxhYmVsOiBzdHJpbmcgPSBudWxsO1xyXG4gIC8qKlxyXG4gICAqV2hlbiBlbmFibGVkLCBhIGNsZWFyIGljb24gaXMgZGlzcGxheWVkIHRvIGNsZWFyIHRoZSB2YWx1ZS5cclxuICAgKi9cclxuICBwdWJsaWMgc2hvd0NsZWFyOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8qKlxyXG4gICAqIGNvbnN0cnVjdG9yXHJcbiAgICogQHBhcmFtIGluaXRcclxuICAgKi9cclxuICBjb25zdHJ1Y3Rvcihpbml0PzogUGFydGlhbDxDYXNjYWRlU2VsZWN0Q29uZmlndXJhdGlvbj4pIHtcclxuICAgIHN1cGVyKCk7XHJcbiAgICBPYmplY3QuYXNzaWduKHRoaXMsIGluaXQpO1xyXG4gIH1cclxufVxyXG5cclxuLyoqXHJcbiAqIERpcmVjdGl2ZVxyXG4gKi9cclxuQERpcmVjdGl2ZSh7XHJcbiAgc2VsZWN0b3I6ICdbc2V0Q2FzY2FkZVNlbGVjdENvbmZpZ3NdJyxcclxufSlcclxuZXhwb3J0IGNsYXNzIFByZ1NldENhc2NhZGVTZWxlY3RDb25maWdzRGlyZWN0aXZlIHtcclxuICAvKipcclxuICAgKiBjb25zdHJ1Y3RvclxyXG4gICAqIEBwYXJhbSBlbGVtZW50XHJcbiAgICovXHJcbiAgY29uc3RydWN0b3IocHJpdmF0ZSBlbGVtZW50OiBDYXNjYWRlU2VsZWN0KSB7fVxyXG5cclxuICAvKipcclxuICAgKiBpbnB1dCBDYXNjYWRlIFNlbGVjdGVkIGNvbmZpZ3MgYW5kIGFzc2lnbiBjb25maWdzIHRvIGVsZW1lbnRcclxuICAgKi9cclxuICBASW5wdXQoKSBzZXQgc2V0Q2FzY2FkZVNlbGVjdENvbmZpZ3MoY29uZmlnczogQ2FzY2FkZVNlbGVjdENvbmZpZ3VyYXRpb24pIHtcclxuICAgIE9iamVjdC5hc3NpZ24odGhpcy5lbGVtZW50LCBjb25maWdzKTtcclxuICB9XHJcbn1cclxuIl19