import { Component, EventEmitter, Input, Output } from '@angular/core';
import { FieldChangeOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "primeng/cascadeselect";
import * as i3 from "@angular/forms";
import * as i4 from "./cascade-select..model";
import * as i5 from "@ngx-translate/core";
/**
 * component Cascade Select
 */
export class PrgCascadeSelectComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgCascadeSelectComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCascadeSelectComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgCascadeSelectComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgCascadeSelectComponent, selector: "prg-cascade-select-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "\r\n<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n  <p-cascadeSelect\r\n    [setCascadeSelectConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n    [inputId]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-cascadeSelect>\r\n\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.CascadeSelect, selector: "p-cascadeSelect", inputs: ["styleClass", "style", "options", "optionLabel", "optionValue", "optionGroupLabel", "optionGroupChildren", "placeholder", "value", "dataKey", "inputId", "tabindex", "ariaLabelledBy", "inputLabel", "ariaLabel", "appendTo", "disabled", "rounded", "showTransitionOptions", "hideTransitionOptions", "showClear", "panelStyleClass", "panelStyle"], outputs: ["onChange", "onGroupChange", "onShow", "onHide", "onClear", "onBeforeShow", "onBeforeHide"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.PrgSetCascadeSelectConfigsDirective, selector: "[setCascadeSelectConfigs]", inputs: ["setCascadeSelectConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCascadeSelectComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-cascade-select-field', template: "\r\n<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n  <p-cascadeSelect\r\n    [setCascadeSelectConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n    [inputId]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-cascadeSelect>\r\n\r\n</div>\r\n" }]
        }], propDecorators: { onValueChange: [{
                type: Output
            }], configs: [{
                type: Input
            }], form: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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