import { Directive, Input } from '@angular/core';
import { BaseField } from '../../../models/base-field';
import { ControlName } from '../../../models/constants/control-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/autocomplete";
/**
 * Class Auto Complete
 */
export class AutoCompleteConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.autoComplete;
        /**
         * An array of data to perform a search for autocomplete purpose
         */
        this.dataToSearch = null;
        /**
         *Field of a suggested object to resolve and display.
         */
        this.field = null;
        /**
         *Maximum height of the suggestions panel.
         */
        this.scrollHeight = '200px';
        /**
         *Displays a button next to the input field when enabled.
         */
        this.dropdown = false;
        /**
         *Specifies if multiple values can be selected.
         */
        this.multiple = false;
        /**
         *Icon class of the dropdown icon.
         */
        this.dropdownIcon = 'pi pi-chevron-down;';
        /**
         *Minimum number of characters to initiate a search.
         */
        this.minLength = 1;
        /**
         *Delay between keystrokes to wait before sending a query.
         */
        this.delay = 300;
        /**
         *Whether to run a query when input receives focus.
         */
        this.completeOnFocus = false;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Inline style of the overlay panel element.
         */
        this.panelStyle = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Style class of the overlay panel element.
         */
        this.panelStyleClass = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *Name of the label field of an option group.
         */
        this.optionGroupLabel = 'label';
        /**
         *Whether to display options as grouped when nested options are provided.
         */
        this.group = false;
        /**
         *Name of the options field of an option group.
         */
        this.optionGroupChildren = 'items';
        /**
         *Hint text for the input field.
         */
        this.placeholder = null;
        /**
         *Maximum number of character allows in the input field.
         */
        this.maxlength = null;
        /**
         *Size of the input field.
         */
        this.size = null;
        /**
         *Target element to attach the overlay, valid values are "body" or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]="mydiv" for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        /**
         *When enabled, highlights the first item in the list by default.
         */
        this.autoHighlight = false;
        /**
         *Type of the input, defaults to "text".
         */
        this.type = 'text';
        /**
         *Whether to show the empty message or not.
         */
        this.showEmptyMessage = false;
        /**
         *Text to display when there is no data. Defaults to global value in i18n translation configuration.
         */
        this.emptyMessage = 'No results found';
        /**
         *Defines how the suggestions should be manipulated. More information is available at "Change Detection" section above.
         */
        this.immutable = true;
        /**
         *When present, it specifies that an input field must be filled out before submitting the form.
         */
        this.required = false;
        /**
         *When present, it specifies that the component should automatically get focus on load.
         */
        this.autofocus = false;
        /**
         *When present, autocomplete clears the manual input if it does not match of the suggestions to force only accepting values from the suggestions.
         */
        this.forceSelection = false;
        /**
         *Specifies the behavior dropdown button. Default "blank" mode sends an empty string and "current" mode sends the input value.
         */
        this.dropdownMode = 'blank';
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        /**
         *Defines a string that labels the input for accessibility.
         */
        this.ariaLabel = null;
        /**
         *Specifies one or more IDs in the DOM that labels the input field.
         */
        this.ariaLabelledBy = null;
        /**
         *Defines a string that labels the dropdown button for accessibility.
         */
        this.dropdownAriaLabel = null;
        /**
         *Ensures uniqueness of selected items on multiple mode.
         */
        this.unique = true;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.autocomplete = null;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        /**
         *Whether the data should be loaded on demand during scroll.
         */
        this.virtualScroll = false;
        /**
         *Height of an item in the list for VirtualScrolling.
         */
        this.virtualScrollItemSize = null;
        /**
         *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
         */
        this.virtualScrollOptions = null;
        /**
         *Defines if data is loaded and interacted with in lazy manner.
         */
        this.lazy = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetAutoCompleteConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Auto Complete configs and assign configs to element
     */
    set setAutoCompleteConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetAutoCompleteConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetAutoCompleteConfigsDirective, deps: [{ token: i1.AutoComplete }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetAutoCompleteConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetAutoCompleteConfigsDirective, selector: "[setAutoCompleteConfigs]", inputs: { setAutoCompleteConfigs: "setAutoCompleteConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetAutoCompleteConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setAutoCompleteConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.AutoComplete }]; }, propDecorators: { setAutoCompleteConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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