import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/utility/array-utility.service";
import * as i2 from "@angular/common";
import * as i3 from "primeng/autocomplete";
import * as i4 from "@angular/forms";
import * as i5 from "./auto-complete.model";
import * as i6 from "@ngx-translate/core";
/**
 * Component Auto Complete
 */
export class PrgAutoCompleteComponent {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService) {
        this.arrayUtilityService = arrayUtilityService;
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the search for auto complete purpose
     */
    search(event) {
        let suggestions = [];
        let query = event.query;
        this.configs.dataToSearch.map((data) => {
            if (this.configs.field) {
                if (data[this.configs.field].toLowerCase().includes(query)) {
                    suggestions.push(data);
                }
            }
            else {
                if (data.toLowerCase().includes(query)) {
                    suggestions.push(data);
                }
            }
        });
        this.configs.suggestions = this.arrayUtilityService.clone(suggestions);
    }
}
PrgAutoCompleteComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAutoCompleteComponent, deps: [{ token: i1.ArrayUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgAutoCompleteComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgAutoCompleteComponent, selector: "prg-auto-complete-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-autoComplete\r\n    [setAutoCompleteConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [emptyMessage]=\"(configs.basePathTranslation + '.' + configs.key + '.emptyMessage' | translate)\"\r\n    [inputId]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.filterPlaceholder'\r\n          | translate\r\n      \"\r\n    (completeMethod)=\"search($event)\"\r\n    [suggestions]=\"configs.suggestions\"\r\n\r\n  ></p-autoComplete>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i3.AutoComplete, selector: "p-autoComplete", inputs: ["minLength", "delay", "style", "panelStyle", "styleClass", "panelStyleClass", "inputStyle", "inputId", "inputStyleClass", "placeholder", "readonly", "disabled", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "maxlength", "name", "required", "size", "appendTo", "autoHighlight", "forceSelection", "type", "autoZIndex", "baseZIndex", "ariaLabel", "dropdownAriaLabel", "ariaLabelledBy", "dropdownIcon", "unique", "group", "completeOnFocus", "showClear", "field", "dropdown", "showEmptyMessage", "dropdownMode", "multiple", "tabindex", "dataKey", "emptyMessage", "showTransitionOptions", "hideTransitionOptions", "autofocus", "autocomplete", "optionGroupChildren", "optionGroupLabel", "itemSize", "suggestions"], outputs: ["completeMethod", "onSelect", "onUnselect", "onFocus", "onBlur", "onDropdownClick", "onClear", "onKeyUp", "onShow", "onHide", "onLazyLoad"] }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i4.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i4.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i5.PrgSetAutoCompleteConfigsDirective, selector: "[setAutoCompleteConfigs]", inputs: ["setAutoCompleteConfigs"] }, { kind: "pipe", type: i6.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAutoCompleteComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-auto-complete-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-autoComplete\r\n    [setAutoCompleteConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [emptyMessage]=\"(configs.basePathTranslation + '.' + configs.key + '.emptyMessage' | translate)\"\r\n    [inputId]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.filterPlaceholder'\r\n          | translate\r\n      \"\r\n    (completeMethod)=\"search($event)\"\r\n    [suggestions]=\"configs.suggestions\"\r\n\r\n  ></p-autoComplete>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ArrayUtilityService }]; }, propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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