import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ActionTypes } from '../models/constants/action-types';
import * as i0 from "@angular/core";
import * as i1 from "ng-dynamic-component";
/**
 * Dynamic form action component
 */
export class PrgDynamicFormActionComponent {
    constructor() {
        /**
         * actions types
         */
        this.actionTypes = ActionTypes;
        /**
         * action Click output
         */
        this.actionClick = new EventEmitter();
        /**
         * output to dynamic component
         */
        this.outputs = {
            actionClick: (action) => {
                this.actionClick.emit(action);
            },
        };
    }
}
PrgDynamicFormActionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormActionComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgDynamicFormActionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDynamicFormActionComponent, selector: "prg-dynamic-form-action", inputs: { action: "action", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<div class=\"button\">\r\n  <ndc-dynamic\r\n    [ndcDynamicComponent]=\"actionTypes[action.controlName]\"\r\n    [ndcDynamicInputs]=\"{ configs: action, form: form }\"\r\n    [ndcDynamicOutputs]=\"outputs\"\r\n  ></ndc-dynamic>\r\n</div>\r\n", styles: [".button{margin:0 5px}\n"], dependencies: [{ kind: "component", type: i1.DynamicComponent, selector: "ndc-dynamic", inputs: ["ndcDynamicComponent", "ndcDynamicInjector", "ndcDynamicProviders", "ndcDynamicContent"], outputs: ["ndcDynamicCreated"] }, { kind: "directive", type: i1.DynamicIoDirective, selector: "[ndcDynamicInputs],[ndcDynamicOutputs]", inputs: ["ndcDynamicInputs", "ndcDynamicOutputs"], exportAs: ["ndcDynamicIo"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormActionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dynamic-form-action', template: "<div class=\"button\">\r\n  <ndc-dynamic\r\n    [ndcDynamicComponent]=\"actionTypes[action.controlName]\"\r\n    [ndcDynamicInputs]=\"{ configs: action, form: form }\"\r\n    [ndcDynamicOutputs]=\"outputs\"\r\n  ></ndc-dynamic>\r\n</div>\r\n", styles: [".button{margin:0 5px}\n"] }]
        }], propDecorators: { action: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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