import { Directive, Input } from '@angular/core';
import { BaseAction } from '../../../models/base-action';
import { ActionName } from '../../../models/constants/action-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/togglebutton";
/**
 * Class ToggleButton Action
 */
export class ToggleButtonActionConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ActionName.ToggleButton;
        /**
         *Enable inline label of the toggle button.
         */
        this.hasLabel = false;
        /**
         *Label for the on state.
         */
        this.onLabel = null;
        /**
         *Label for the off state.
         */
        this.offLabel = null;
        /**
         *Icon for the on state.
         */
        this.onIcon = 'pi pi-check';
        /**
         *Icon for the off state.
         */
        this.offIcon = 'pi pi-times';
        /**
         *Position of the icon, valid values are "left" and "right".
         */
        this.iconPos = 'left';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetToggleButtonActionConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input ToggleButton configs and assign configs to element
     */
    set setToggleButtonActionConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetToggleButtonActionConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetToggleButtonActionConfigsDirective, deps: [{ token: i1.ToggleButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetToggleButtonActionConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetToggleButtonActionConfigsDirective, selector: "[setToggleButtonActionConfigs]", inputs: { setToggleButtonActionConfigs: "setToggleButtonActionConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetToggleButtonActionConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setToggleButtonActionConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.ToggleButton }]; }, propDecorators: { setToggleButtonActionConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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