import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ActionOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "primeng/togglebutton";
import * as i2 from "./toggle-button-action.model";
import * as i3 from "@ngx-translate/core";
/**
 * Toggle Button Action Component
 */
export class PrgToggleButtonActionComponent {
    constructor() {
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onButtonClicked(event) {
        this.actionClick.emit(new ActionOutput({ action: this.configs.key, value: event.checked }));
    }
}
PrgToggleButtonActionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgToggleButtonActionComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgToggleButtonActionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgToggleButtonActionComponent, selector: "prg-toggle-button-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<div class=\"field-checkbox\">\r\n    <p-toggleButton\r\n      (onChange)=\"onButtonClicked($event)\"\r\n      [setToggleButtonActionConfigs]=\"configs\"\r\n      [inputId]=\"configs.key\"\r\n      [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n      [onLabel]=\"configs.hasLabel?(configs.translationBasePath + '.' + configs.key + '.onLabel' | translate):''\"\r\n      [offLabel]=\"configs.hasLabel?(configs.translationBasePath + '.' + configs.key + '.offLabel' | translate):''\"\r\n      ></p-toggleButton>\r\n  <label for=\"{{configs.key}}\">{{configs.translationBasePath + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n\r\n", dependencies: [{ kind: "component", type: i1.ToggleButton, selector: "p-toggleButton", inputs: ["onLabel", "offLabel", "onIcon", "offIcon", "ariaLabelledBy", "disabled", "style", "styleClass", "inputId", "tabindex", "iconPos"], outputs: ["onChange"] }, { kind: "directive", type: i2.PrgSetToggleButtonActionConfigsDirective, selector: "[setToggleButtonActionConfigs]", inputs: ["setToggleButtonActionConfigs"] }, { kind: "pipe", type: i3.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgToggleButtonActionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-toggle-button-action', template: "<div class=\"field-checkbox\">\r\n    <p-toggleButton\r\n      (onChange)=\"onButtonClicked($event)\"\r\n      [setToggleButtonActionConfigs]=\"configs\"\r\n      [inputId]=\"configs.key\"\r\n      [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n      [onLabel]=\"configs.hasLabel?(configs.translationBasePath + '.' + configs.key + '.onLabel' | translate):''\"\r\n      [offLabel]=\"configs.hasLabel?(configs.translationBasePath + '.' + configs.key + '.offLabel' | translate):''\"\r\n      ></p-toggleButton>\r\n  <label for=\"{{configs.key}}\">{{configs.translationBasePath + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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