import { Directive, Input } from '@angular/core';
import { BaseAction } from '../../../models/base-action';
import { ActionName } from '../../../models/constants/action-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/splitbutton";
/**
 * Split Button Model
 */
export class SplitButtonConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * Control name
         */
        this.controlName = ActionName.SplitButton;
        /**
         *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Indicates the direction of the element.
         */
        this.dir = null;
        /**
         *When present, it specifies that the component should be disabled.
         */
        this.disabled = false;
        /**
         *Defines a string that labels the expand button for accessibility.
         */
        this.expandAriaLabel = null;
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '195ms ease-in';
        /**
         *Name of the icon.
         */
        this.icon = null;
        /**
         *Position of the icon, valid values are left and right.
         */
        this.iconPos = 'left';
        /**
         *Text of the button.
         */
        this.label = null;
        /**
         *Inline style of the overlay menu.
         */
        this.menuStyle = null;
        /**
         *Style class of the overlay menu.
         */
        this.menuStyleClass = null;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '225ms ease-out';
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSplitButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * set button configs, assign configs received to element
     */
    set setSplitButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSplitButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSplitButtonConfigsDirective, deps: [{ token: i1.SplitButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSplitButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSplitButtonConfigsDirective, selector: "[setSplitButtonConfigs]", inputs: { setSplitButtonConfigs: "setSplitButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSplitButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSplitButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.SplitButton }]; }, propDecorators: { setSplitButtonConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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