import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ActionOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/utility/array-utility.service";
import * as i2 from "primeng/splitbutton";
import * as i3 from "./split-button.model";
import * as i4 from "@ngx-translate/core";
/**
 * component split button
 */
export class PrgSplitButtonComponent {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService) {
        this.arrayUtilityService = arrayUtilityService;
        /**
         * Data of split button menu
         * @type {PrgMenuItem[]}
         */
        this.menuButton = [];
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * Split Button configs
     */
    set configs(configs) {
        this._configs = configs;
        this.assignCommandsToMenuButton(configs.items);
    }
    /**
     * Getter of configs
     * @returns {SplitButtonConfiguration}
     */
    get configs() {
        return this._configs;
    }
    /**
     * function that triggers the output
     * @param {PrgMenuItem} menuItem
     */
    onButtonClicked(menuItem = null) {
        if (menuItem?.key) {
            this.actionClick.emit({
                action: menuItem?.key,
                group: menuItem?.group,
            });
        }
        else {
            this.actionClick.emit(new ActionOutput({ action: this.configs.key }));
        }
    }
    /**
     * Assign commands to menu button
     * @param {PrgMenuItem[]} menuItems
     */
    assignCommandsToMenuButton(menuItems) {
        this.menuButton = this.arrayUtilityService.clone(menuItems);
        this.menuButton.map((item) => {
            let path;
            path = item?.label;
            if (item.key) {
                item.command = (event) => {
                    this.onButtonClicked(event.item);
                };
                item.group = path;
            }
            if (item.items != null && item.items.length > 0) {
                let children = item.items;
                children.forEach((itemChildren) => {
                    return this.iterateOverChildren(itemChildren, path);
                });
            }
        });
    }
    /**
     * Iterate over all children of menu button
     * @param {PrgMenuItem} itemChildren
     * @param {string} path
     * @returns {PrgMenuItem}
     */
    iterateOverChildren(itemChildren, path) {
        let currentChildren = itemChildren;
        path = path + ':' + itemChildren.label;
        if (currentChildren.key) {
            currentChildren.command = (event) => {
                this.onButtonClicked(event.item);
            };
            itemChildren.group = path;
        }
        if (currentChildren.items != null && currentChildren.items.length > 0) {
            currentChildren.items.forEach((child) => {
                if (child.key) {
                    child.group = path + ':' + child.label;
                    child.command = (event) => {
                        this.onButtonClicked(event.item);
                    };
                }
                if (child.items != null && child.items.length > 0) {
                    this.iterateOverChildren(child, path);
                }
            });
        }
        return currentChildren;
    }
}
PrgSplitButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSplitButtonComponent, deps: [{ token: i1.ArrayUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgSplitButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSplitButtonComponent, selector: "prg-button-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<p-splitButton\r\n  [setSplitButtonConfigs]=\"configs\"\r\n  [label]=\"configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n\"\r\n  [model]=\"menuButton\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!||configs.disabled\"\r\n  (onClick)=\"onButtonClicked()\"\r\n></p-splitButton>\r\n", dependencies: [{ kind: "component", type: i2.SplitButton, selector: "p-splitButton", inputs: ["model", "icon", "iconPos", "label", "style", "styleClass", "menuStyle", "menuStyleClass", "disabled", "tabindex", "appendTo", "dir", "expandAriaLabel", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onClick", "onDropdownClick"] }, { kind: "directive", type: i3.PrgSplitButtonConfigsDirective, selector: "[setSplitButtonConfigs]", inputs: ["setSplitButtonConfigs"] }, { kind: "pipe", type: i4.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSplitButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-button-action', template: "<p-splitButton\r\n  [setSplitButtonConfigs]=\"configs\"\r\n  [label]=\"configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n\"\r\n  [model]=\"menuButton\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!||configs.disabled\"\r\n  (onClick)=\"onButtonClicked()\"\r\n></p-splitButton>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ArrayUtilityService }]; }, propDecorators: { configs: [{
                type: Input,
                args: ['configs']
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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