import { Directive, Input } from '@angular/core';
import { BaseAction } from '../../../models/base-action';
import { ActionName } from '../../../models/constants/action-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/speeddial";
/**
 * class SpeedDialConfiguration
 */
export class SpeedDialConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * Control name
         */
        this.controlName = ActionName.SpeedDial;
        /**
         *Style class of the button element.
         */
        this.buttonClassName = null;
        /**
         *Inline style of the button element.
         */
        this.buttonStyle = null;
        /**
         *Template of button element.
         */
        this.buttonTemplate = null;
        /**
         *Style class of the element.
         */
        this.className = null;
        /**
         *Specifies the opening direction of actions. Valid values are 'up', 'down', 'left', 'right', 'up-left', 'up-right', 'down-left' and 'down-right'
         */
        this.direction = 'up';
        /**
         *Whether the component is disabled.
         */
        this.disabled = false;
        /**
         *Hide icon of the button element.
         */
        this.hideIcon = null;
        /**
         *Whether the actions close when clicked outside.
         */
        this.hideOnClickOutside = true;
        /**
         *Unique identifier of the element.
         */
        this.id = null;
        /**
         *Whether to show a mask element behind the speeddial
         */
        this.mask = false;
        /**
         *Style class of the mask element.
         */
        this.maskClassName = null;
        /**
         *Inline style of the mask element.
         */
        this.maskStyle = null;
        /**
         *MenuModel instance to define the action items.
         */
        this.model = null;
        /**
         *Radius for *circle types.
         */
        this.radius = 0;
        /**
         *Defined to rotate showIcon when hideIcon is not present.
         */
        this.rotateAnimation = true;
        /**
         *Show icon of the button element.
         */
        this.showIcon = 'pi pi-plus';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Transition delay step for each action item.
         */
        this.transitionDelay = 30;
        /**
         *Specifies the visibility of the overlay.
         */
        this.visible = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSpeedDialConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * set button configs, assign configs received to element
     */
    set setSpeedDialConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSpeedDialConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpeedDialConfigsDirective, deps: [{ token: i1.SpeedDial }], target: i0.ɵɵFactoryTarget.Directive });
PrgSpeedDialConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSpeedDialConfigsDirective, selector: "[setSpeedDialConfigs]", inputs: { setSpeedDialConfigs: "setSpeedDialConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpeedDialConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSpeedDialConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.SpeedDial }]; }, propDecorators: { setSpeedDialConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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