import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../../../../services/utility/array-utility.service";
import * as i2 from "primeng/speeddial";
import * as i3 from "./speed-dial.model";
/**
 * component speed dial
 */
export class PrgSpeedDialComponent {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService) {
        this.arrayUtilityService = arrayUtilityService;
        /**
         * Data of speed button menu
         * @type {PrgMenuItem[]}
         */
        this.menuButton = [];
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * Speed Dial configs
     */
    set configs(configs) {
        this._configs = configs;
        this.assignCommandsToMenuButton(configs.items);
    }
    /**
     * Getter of configs
     * @returns {SpeedDialConfiguration}
     */
    get configs() {
        return this._configs;
    }
    /**
     * function that triggers the output
     * @param {PrgMenuItem} menuItem
     */
    onButtonClicked(menuItem) {
        if (menuItem?.key) {
            this.actionClick.emit({
                action: menuItem?.key,
                group: menuItem?.group,
            });
        }
    }
    /**
     * Assign commands to menu button
     * @param {PrgMenuItem[]} menuItems
     */
    assignCommandsToMenuButton(menuItems) {
        this.menuButton = this.arrayUtilityService.clone(menuItems);
        this.menuButton.map((item) => {
            if (item.key) {
                item.command = (event) => {
                    this.onButtonClicked(event.item);
                };
            }
        });
    }
}
PrgSpeedDialComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpeedDialComponent, deps: [{ token: i1.ArrayUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgSpeedDialComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSpeedDialComponent, selector: "prg-speed-dial-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<p-speedDial\r\n  [setSpeedDialConfigs]=\"configs\"\r\n  [model]=\"menuButton\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n></p-speedDial>\r\n", dependencies: [{ kind: "component", type: i2.SpeedDial, selector: "p-speedDial", inputs: ["id", "model", "visible", "style", "className", "direction", "transitionDelay", "type", "radius", "mask", "disabled", "hideOnClickOutside", "buttonStyle", "buttonClassName", "maskStyle", "maskClassName", "showIcon", "hideIcon", "rotateAnimation"], outputs: ["onVisibleChange", "visibleChange", "onClick", "onShow", "onHide"] }, { kind: "directive", type: i3.PrgSpeedDialConfigsDirective, selector: "[setSpeedDialConfigs]", inputs: ["setSpeedDialConfigs"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpeedDialComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-speed-dial-action', template: "<p-speedDial\r\n  [setSpeedDialConfigs]=\"configs\"\r\n  [model]=\"menuButton\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n></p-speedDial>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ArrayUtilityService }]; }, propDecorators: { configs: [{
                type: Input,
                args: ['configs']
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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