import { Directive, Input } from '@angular/core';
import { BaseAction } from '../../../models/base-action';
import { ActionName } from '../../../models/constants/action-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/selectbutton";
/**
 * Class Select Button Action
 */
export class SelectButtonActionConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ActionName.SelectButton;
        /**
         *An array of selectitems to display as the available options.
         */
        this.options = null;
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *When specified, allows selecting multiple values.
         */
        this.multiple = false;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = 0;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetSelectButtonActionConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * Set Select Button configs and assign configs to element
     */
    set setSelectButtonActionConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetSelectButtonActionConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectButtonActionConfigsDirective, deps: [{ token: i1.SelectButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetSelectButtonActionConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetSelectButtonActionConfigsDirective, selector: "[setSelectButtonActionConfigs]", inputs: { setSelectButtonActionConfigs: "setSelectButtonActionConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectButtonActionConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSelectButtonActionConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.SelectButton }]; }, propDecorators: { setSelectButtonActionConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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