import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ActionOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "primeng/selectbutton";
import * as i2 from "./select-button-action.model";
import * as i3 from "@ngx-translate/core";
/**
 * component select button
 */
export class PrgSelectButtonActionComponent {
    constructor() {
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onButtonClicked(event) {
        this.actionClick.emit(new ActionOutput({
            action: this.configs.key,
            value: event?.option?.value,
            group: event?.option?.name,
        }));
    }
}
PrgSelectButtonActionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectButtonActionComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgSelectButtonActionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSelectButtonActionComponent, selector: "prg-select-button-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<p>{{\r\n    configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n    }}</p>\r\n<p-selectButton\r\n  (onOptionClick)=\"onButtonClicked($event)\"\r\n  [setSelectButtonActionConfigs]=\"configs\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n  >\r\n</p-selectButton>\r\n\r\n", dependencies: [{ kind: "component", type: i1.SelectButton, selector: "p-selectButton", inputs: ["options", "optionLabel", "optionValue", "optionDisabled", "tabindex", "multiple", "style", "styleClass", "ariaLabelledBy", "disabled", "dataKey"], outputs: ["onOptionClick", "onChange"] }, { kind: "directive", type: i2.PrgSetSelectButtonActionConfigsDirective, selector: "[setSelectButtonActionConfigs]", inputs: ["setSelectButtonActionConfigs"] }, { kind: "pipe", type: i3.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectButtonActionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-button-action', template: "<p>{{\r\n    configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n    }}</p>\r\n<p-selectButton\r\n  (onOptionClick)=\"onButtonClicked($event)\"\r\n  [setSelectButtonActionConfigs]=\"configs\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n  >\r\n</p-selectButton>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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