import { Directive, Input } from '@angular/core';
import { BaseAction } from '../../../models/base-action';
import { ActionName } from '../../../models/constants/action-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/inputswitch";
/**
 * Class Input Switch Action
 */
export class InputSwitchActionConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ActionName.InputSwitch;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the input element.
         */
        this.inputId = null;
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.ariaLabel = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgSetInputSwitchActionConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * Input Switch Action configs and assign configs to element
     */
    set setInputSwitchActionConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputSwitchActionConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputSwitchActionConfigsDirective, deps: [{ token: i1.InputSwitch }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputSwitchActionConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputSwitchActionConfigsDirective, selector: "[setInputSwitchActionConfigs]", inputs: { setInputSwitchActionConfigs: "setInputSwitchActionConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputSwitchActionConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputSwitchActionConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.InputSwitch }]; }, propDecorators: { setInputSwitchActionConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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