import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ActionOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "primeng/inputswitch";
import * as i2 from "./input-switch-action.model";
import * as i3 from "@ngx-translate/core";
/**
 * Component Input Switch Action
 */
export class PrgInputSwitchActionComponent {
    constructor() {
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onButtonClicked(event) {
        this.actionClick.emit(new ActionOutput({ action: this.configs.key, value: event.checked }));
    }
}
PrgInputSwitchActionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputSwitchActionComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgInputSwitchActionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputSwitchActionComponent, selector: "prg-input-switch-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<div class=\"field-checkbox\">\r\n  <p-inputSwitch\r\n    (onChange)=\"onButtonClicked($event)\"\r\n    [setInputSwitchActionConfigs]=\"configs\"\r\n    [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n    [inputId]=\"configs.key\"></p-inputSwitch>\r\n  <label for=\"{{configs.key}}\">{{configs.translationBasePath + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n", dependencies: [{ kind: "component", type: i1.InputSwitch, selector: "p-inputSwitch", inputs: ["style", "styleClass", "tabindex", "inputId", "name", "disabled", "readonly", "trueValue", "falseValue", "ariaLabel", "ariaLabelledBy"], outputs: ["onChange"] }, { kind: "directive", type: i2.PrgSetInputSwitchActionConfigsDirective, selector: "[setInputSwitchActionConfigs]", inputs: ["setInputSwitchActionConfigs"] }, { kind: "pipe", type: i3.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputSwitchActionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-switch-action', template: "<div class=\"field-checkbox\">\r\n  <p-inputSwitch\r\n    (onChange)=\"onButtonClicked($event)\"\r\n    [setInputSwitchActionConfigs]=\"configs\"\r\n    [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n    [inputId]=\"configs.key\"></p-inputSwitch>\r\n  <label for=\"{{configs.key}}\">{{configs.translationBasePath + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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