import { Directive, Input } from '@angular/core';
import { BaseAction } from '../../../models/base-action';
import { ActionName } from '../../../models/constants/action-names';
import * as i0 from "@angular/core";
import * as i1 from "primeng/button";
/**
 * class ButtonConfiguration
 */
export class ButtonConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * Control name
         */
        this.controlName = ActionName.Button;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.ariaLabel = null;
        /**
         *Value of the badge.
         */
        this.badge = null;
        /**
         *Style class of the badge.
         */
        this.badgeClass = null;
        /**
         *When present, it specifies that the component should be disabled.
         */
        this.disabled = false;
        /**
         *Name of the icon.
         */
        this.icon = null;
        /**
         *Position of the icon, valid values are left and right.
         */
        this.iconPos = 'left';
        /**
         *Text of the button.
         */
        this.label = null;
        /**
         *Whether the button is in loading state.
         */
        this.loading = false;
        /**
         *Icon to display in loading state.
         */
        this.loadingIcon = 'pi pi-spinner pi-spin';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
export class PrgButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * set button configs, assign configs received to element
     */
    set setButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgButtonConfigsDirective, deps: [{ token: i1.Button }], target: i0.ɵɵFactoryTarget.Directive });
PrgButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgButtonConfigsDirective, selector: "[setButtonConfigs]", inputs: { setButtonConfigs: "setButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1.Button }]; }, propDecorators: { setButtonConfigs: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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