import { Component, EventEmitter, Input, Output } from '@angular/core';
import { ActionOutput } from '../../../models/base-action';
import * as i0 from "@angular/core";
import * as i1 from "primeng/button";
import * as i2 from "./button.model";
import * as i3 from "@ngx-translate/core";
/**
 * component button
 */
export class PrgButtonComponent {
    constructor() {
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onButtonClicked() {
        this.actionClick.emit(new ActionOutput({ action: this.configs.key }));
    }
}
PrgButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgButtonComponent, selector: "prg-button-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<p-button\r\n\r\n  [setButtonConfigs]=\"configs\"\r\n  [label]=\"\r\n    configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n  \"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n  (onClick)=\"onButtonClicked()\"\r\n></p-button>\r\n\r\n", dependencies: [{ kind: "component", type: i1.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "directive", type: i2.PrgButtonConfigsDirective, selector: "[setButtonConfigs]", inputs: ["setButtonConfigs"] }, { kind: "pipe", type: i3.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-button-action', template: "<p-button\r\n\r\n  [setButtonConfigs]=\"configs\"\r\n  [label]=\"\r\n    configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n  \"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n  (onClick)=\"onButtonClicked()\"\r\n></p-button>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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