import { BaseAction, BaseActionKey } from '../models/base-action';
import { ActionName } from '../models/constants/action-names';
import { ToolbarSlot } from '../models/constants/toolbar-slots';
/**
 * Default actions
 * This array contains the add, edit, save and cancel actions,
 * as well as the visibility expression for the logic of these actions
 */
export const ACTIONS_BASE_STRUCTURE = {
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Add,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='add' || this.viewMode ==='read'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='read'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='edit'",
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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