import { BehaviorSubject } from 'rxjs';
/**
 * ConfigurationItemsService class that defines an
 * <br />abstract authentication service to
 * <br />be extended by the mock and real
 * <br />configuration items services
 */
export class AbstractConfigurationItemsService {
    constructor() {
        /**
         * Current configurationItems
         */
        this.configurationItemsSubject = new BehaviorSubject(null);
    }
    /**
     * Setter for configurationItemsSubject
     *
     * @param {ConfigurationItem[]} value The ConfigurationItems array
     */
    setConfigurationItems(value) {
        this.configurationItemsSubject.next(value);
    }
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject as an observable
     */
    getConfigurationItemsObservable() {
        return this.configurationItemsSubject.asObservable();
    }
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject current value
     */
    getConfigurationItemsValue() {
        return this.configurationItemsSubject.getValue();
    }
}
//# sourceMappingURL=data:application/json;base64,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