import { NgModule } from '@angular/core';
import { PrgCoreDynamicFormModule } from '../core/components/dynamic-form/prg-core-dynamic-form.module';
import { PrgSharedComponentsModule } from '../shared-components/shared-components.module';
import { PrgConfigItemsAdminComponent } from './components/config-items-admin/prg-config-items-admin.component';
import { PrgConfigItemsUserComponent } from './components/config-items-user/prg-config-items-user.component';
import { MockConfigurationItemsService } from './mock/services/configuration-items.service.mock';
import { PrgConfigurationItemsRoutingModule } from './prg-configuration-items-routing.module';
import { AbstractConfigurationItemsService } from './services/configuration-items/abstract-configuration-items.service';
import { ConfigurationItemsService } from './services/configuration-items/configuration-items.service';
import { PRG_CONFIGURATION_ITEMS_CONFIG } from './services/prg-configuration-items-config/prg-configuration-items-config.service';
import * as i0 from "@angular/core";
/**
 * Module that handles authentication
 */
export class PrgConfigurationItemsModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgConfigurationItemsConfig) {
        configurationItemsConfig = prgConfigurationItemsConfig;
        return {
            ngModule: PrgConfigurationItemsModule,
            providers: [
                {
                    provide: PRG_CONFIGURATION_ITEMS_CONFIG,
                    useValue: prgConfigurationItemsConfig,
                },
                {
                    provide: AbstractConfigurationItemsService,
                    useClass: prgConfigurationItemsConfig.useMockServices
                        ? MockConfigurationItemsService
                        : ConfigurationItemsService,
                },
            ],
        };
    }
}
PrgConfigurationItemsModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgConfigurationItemsModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsModule, declarations: [PrgConfigItemsUserComponent, PrgConfigItemsAdminComponent], imports: [PrgSharedComponentsModule,
        PrgConfigurationItemsRoutingModule,
        PrgCoreDynamicFormModule] });
PrgConfigurationItemsModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsModule, imports: [PrgSharedComponentsModule,
        PrgConfigurationItemsRoutingModule,
        PrgCoreDynamicFormModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [PrgConfigItemsUserComponent, PrgConfigItemsAdminComponent],
                    imports: [
                        PrgSharedComponentsModule,
                        PrgConfigurationItemsRoutingModule,
                        PrgCoreDynamicFormModule,
                    ],
                    exports: [],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the ConfigItemsCoreConfig object
 */
export let configurationItemsConfig;
//# sourceMappingURL=data:application/json;base64,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