/**
 * ConfigurationItem class that defines generic configurations
 */
import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * The model of Configuration Items
 */
export class ConfigurationItem extends BaseEntity {
    //isSystem
    /**
     * Constructor
     * @param {Partial<ConfigurationItem>} init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Enum of most common sub-paths of config items
 */
export var ConfigItemsPath;
(function (ConfigItemsPath) {
    ConfigItemsPath["Defaults"] = "Defaults";
    ConfigItemsPath["UserPreferences"] = "User-Preferences";
})(ConfigItemsPath || (ConfigItemsPath = {}));
//# sourceMappingURL=data:application/json;base64,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