import { CheckboxConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/checkbox/checkbox.model';
import { InputNumberConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/input-number/input-number.model';
import { SelectConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/select/select.model';
import { ControlName } from '../../core/components/dynamic-form/models/constants/control-names';
import { ReferenceType } from '../../core/components/dynamic-form/models/constants/reference-type';
/**
 * MockDatabase object to be used while developing
 * <br /> and/or testing the front-end
 */
export const MockDatabase = {
    ConfigurationItems: [
        {
            id: '1',
            name: 'language',
            createdBy: '1',
            path: 'Config-Items:User-Preferences:Defaults',
            value: 'language.portuguese',
            guiSettings: JSON.stringify(new SelectConfiguration({
                controlName: ControlName.dropdown,
                referenceType: ReferenceType.LookupTable,
                referenceName: 'language',
                key: 'language',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '2',
            name: 'language',
            createdBy: '2',
            path: 'Config-Items:User-Preferences:pedrocouto@gmail.com',
            value: 'language.english',
            guiSettings: JSON.stringify(new SelectConfiguration({
                referenceType: ReferenceType.LookupTable,
                referenceName: 'language',
                key: 'language',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '3',
            name: 'theme',
            createdBy: '1',
            path: 'Config-Items:User-Preferences:Defaults',
            value: 'theme.lara-light-blue',
            guiSettings: JSON.stringify(new SelectConfiguration({
                referenceType: ReferenceType.LookupTable,
                referenceName: 'theme',
                key: 'theme',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '4',
            name: 'theme',
            createdBy: '3',
            path: 'Config-Items:User-Preferences:pedrolima@gmail.com',
            value: 'theme.bootstrap4-dark-purple',
            guiSettings: JSON.stringify(new SelectConfiguration({
                referenceType: ReferenceType.LookupTable,
                referenceName: 'theme',
                key: 'theme',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '5',
            name: 'theme',
            createdBy: '4',
            path: 'Config-Items:User-Preferences:luis@gmail.com',
            value: 'theme.rhea',
            guiSettings: JSON.stringify(new SelectConfiguration({
                referenceType: ReferenceType.LookupTable,
                referenceName: 'theme',
                key: 'theme',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '7',
            name: 'RequiredLength',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: 5,
            guiSettings: JSON.stringify(new InputNumberConfiguration({
                key: 'RequiredLength',
                min: 1,
                max: 10,
                showButtons: true,
                validators: ['Validators.required'],
                basePathTranslation: 'config-items.identity.password',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '9',
            name: 'RequiredUniqueChars',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: '1',
            guiSettings: JSON.stringify(new InputNumberConfiguration({
                key: 'RequiredUniqueChars',
                min: 1,
                max: 10,
                showButtons: true,
                validators: ['Validators.required'],
                basePathTranslation: 'config-items.identity.password',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '8',
            name: 'RequireLowercase',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: true,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'RequireLowercase',
                basePathTranslation: 'config-items.identity.password',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '6',
            name: 'RequireDigit',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: false,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'RequireDigit',
                basePathTranslation: 'config-items.identity.password',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '10',
            name: 'RequireUppercase',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: true,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'RequireUppercase',
                basePathTranslation: 'config-items.identity.password',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '11',
            name: 'RequireNonAlphanumeric',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: true,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'RequireNonAlphanumeric',
                validators: ['Validators.required'],
                basePathTranslation: 'config-items.identity.password',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '12',
            name: 'AllowSelfRegister',
            createdBy: '1',
            path: 'Config-Items:Identity',
            value: true,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'AllowSelfRegister',
                basePathTranslation: 'config-items.identity',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
    ],
    /* TODO: MAP Identity CONFIG TO CONFIGURATION ITEMS
      "Identity": {
        "DefaultEnabledUser": true, // user will be enabled on register
        "AllowSelfRegister": true,
        "LockoutEnabled": true,
        "CreateWorkspaceOnUserRegister": true,
        "SignIn": {
          "RequireEnabledUser": false,
          "RequireConfirmedAdmin": false,
          "RequireConfirmedEmail": true,
          "RequireConfirmedPhoneNumber": false
        },
        "Lockout": {
          "LockoutTimeSpan": "1.00:00:00" //lock out for 1 day
        },
        "Password": {
          "RequireDigit": true,
          "RequiredLength": 7,
          "RequireLowercase": true,
          "RequiredUniqueChars": 1,
          "RequireUppercase": true,
          "RequireNonAlphanumeric": true
        },
        "Callbacks": {
          "BaseUrl": "http://localhost:8100",
          "LoginUrl": "/auth/login",
          "ConfirmedAccountUrl": "/auth/confirm",
          "ResetPasswordUrl": "/auth/reset",
          "UnsubscribeUrl": "/auth/unsubscribe"
        },
        "Token": {
          "Audience": "Prg.Framework.Api.Audience",
          "Issuer": "Prg.Framework.Api.Issuer",
          "Seconds": 86400, // 24 hours
          "RefreshDuration": 24 // 24 hours
        }
      }
    */
};
//# sourceMappingURL=data:application/json;base64,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