import { BaseAction, BaseActionKey, } from '../../core/components/dynamic-form/models/base-action';
import { ActionName } from '../../core/components/dynamic-form/models/constants/action-names';
import { ToolbarSlot } from '../../core/components/dynamic-form/models/constants/toolbar-slots';
/**
 * Constant that defines the fields and actions for the dynamic form config items
 */
export const CONFIG_ITEMS_DYNAMIC_FORM = {
    fields: [],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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