import { Component, Input } from '@angular/core';
import { BaseActionKey, } from '../../../core/components/dynamic-form/models/base-action';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { CONFIG_ITEMS_DYNAMIC_FORM } from '../../dynamic-form-structure/config-items-dynamic-form';
import * as i0 from "@angular/core";
import * as i1 from "../../services/configuration-items/abstract-configuration-items.service";
import * as i2 from "../../../core/services/utility/array-utility.service";
import * as i3 from "../../../core/services/utility/utility.service";
import * as i4 from "@ngx-translate/core";
import * as i5 from "../../../core/services/utility/objects-utility.service";
import * as i6 from "../../../auth/services/auth/abstract-auth.service";
import * as i7 from "@angular/common";
import * as i8 from "../../../core/components/dynamic-form/prg-dynamic-form.component";
/**
 * Config items user component
 */
export class PrgConfigItemsUserComponent {
    /**
     * Constructor
     * @param {AbstractConfigurationItemsService} configurationItemsService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {UtilityService} utilityService
     * @param {TranslateService} translateService
     * @param {ObjectsUtilityService} objectUtility
     * @param {AbstractAuthService} authService
     */
    constructor(configurationItemsService, arrayUtilityService, utilityService, translateService, objectUtility, authService) {
        this.configurationItemsService = configurationItemsService;
        this.arrayUtilityService = arrayUtilityService;
        this.utilityService = utilityService;
        this.translateService = translateService;
        this.objectUtility = objectUtility;
        this.authService = authService;
        /**
         * The view mode type of the form. Default is "read"
         * @type {ViewMode}
         */
        this.configItemsViewMode = ViewMode.Read;
        /**
         * The complete path for the config item user-preferences defaults
         * @type {string}
         */
        this.configItemUserPreferencesDefaultsPath = 'Config-Items:User-Preferences:';
        /**
         * A boolean property of the class to show/hide form. Default is false(hide)
         * @type {boolean}
         */
        this.initForm = false;
        /**
         * An object with the data to build form , keys and values
         * @type {any}
         */
        this.entityConfigItems = {};
        /**
         * The dynamic form fields to build dynamic form config items in template
         */
        this.configItemsDynamicFormFields = this.arrayUtilityService.clone(CONFIG_ITEMS_DYNAMIC_FORM.fields);
        /**
         * The dynamic form actions to build dynamic form config items in template
         */
        this.configItemsDynamicFormActions = this.arrayUtilityService.clone(CONFIG_ITEMS_DYNAMIC_FORM.actions);
        /**
         * A copy of entityConfigItems object
         * @type {any}
         * @private
         */
        this.entityConfigItemCopy = {};
        /**
         * User and defaults config items
         * @type {any}
         */
        this.userAndDefaultsConfigsItems = {};
        /**
         * The configuration items defaults of user preferences
         * @type {ConfigurationItem[]}
         * @private
         */
        this.configItemsUserPreferencesDefaults = [];
        /**
         * The configuration items of user preferences of current user
         * @type {ConfigurationItem[]}
         * @private
         */
        this.configItemsUserPreferences = [];
    }
    /**
     * ngOnInit
     *
     * Get  configuration items User Preferences and settings to initiate the template
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        this.userAndDefaultsConfigsItems =
            await this.configurationItemsService.getConfigurationItemsByPathAsync(this.configItemUserPreferencesDefaultsPath);
        this.configItemsUserPreferencesDefaults = this.objectUtility.cloneObject(this.userAndDefaultsConfigsItems.defaults);
        await this.getConfigItemsUserPreferencesByLoggedUser();
        this.configItemsDynamicFormFields = this.arrayUtilityService.clone(this.getAndParseGuiSettingsItems());
        this.assignConfigItemDataToForm();
        this.setTitleForm();
        //Initiate Form
        this.initForm = true;
    }
    /**
     * This function is responsible to get Config Items regarding user logged
     * @returns {Promise<void>}
     */
    async getConfigItemsUserPreferencesByLoggedUser() {
        this.loggedUser = this.objectUtility.cloneObject(this.authService.getLoggedUser());
        this.configItemUserPath =
            this.configItemUserPreferencesDefaultsPath + this.loggedUser?.email;
        this.configItemsUserPreferences = this.objectUtility.cloneObject(this.userAndDefaultsConfigsItems.user);
    }
    /**
     * This function is responsible to get the gui settings of config item and parse it
     * @returns {any}
     * @private
     */
    getAndParseGuiSettingsItems() {
        //Gui Settings
        let guiSettings;
        if (this.configItemsUserPreferencesDefaults != null &&
            this.configItemsUserPreferencesDefaults.length > 0) {
            guiSettings = this.configItemsUserPreferencesDefaults.map((configItem) => {
                return this.utilityService.guiSettingToObject(configItem.guiSettings);
            });
        }
        else {
            guiSettings = [];
        }
        return guiSettings;
    }
    /**
     * This function will assign config items data to form
     * @private
     */
    assignConfigItemDataToForm() {
        // Assign config item data to form - entities
        const mapConfigItemsIntoEntity = [];
        this.configItemsUserPreferences.map((configItems) => {
            mapConfigItemsIntoEntity[configItems.name] = configItems.value;
        });
        if (this.configItemsUserPreferencesDefaults != null &&
            this.configItemsUserPreferencesDefaults.length > 0) {
            this.configItemsUserPreferencesDefaults.map(async (configItems) => {
                if (!mapConfigItemsIntoEntity[configItems.name]) {
                    mapConfigItemsIntoEntity[configItems.name] = null;
                }
                let fieldGuiSettings = this.configItemsDynamicFormFields.find((value) => value.key === configItems.name);
                if (fieldGuiSettings.basePathTranslation.includes('lookup-tables')) {
                    fieldGuiSettings.placeholder =
                        this.translateService.instant(fieldGuiSettings.basePathTranslation +
                            '.' +
                            fieldGuiSettings.key +
                            '.items.' +
                            configItems.value +
                            '.name') + ' (default)';
                }
                else {
                    fieldGuiSettings.placeholder = configItems.value + ' (default)';
                }
            });
        }
        mapConfigItemsIntoEntity['path'] = this.configItemUserPath;
        this.entityConfigItems = Object.assign({}, mapConfigItemsIntoEntity);
        this.entityConfigItemCopy = this.objectUtility.cloneObject(this.entityConfigItems);
    }
    /**
     * This function will set the title of the form
     * @private
     */
    setTitleForm() {
        // Title of Form
        if (this.entityConfigItems.path) {
            this.titleForm = this.entityConfigItems.path
                .substring(0, this.entityConfigItems.path.lastIndexOf(':'))
                .replaceAll(':', '.')
                .toLowerCase();
        }
    }
    /**
     * This function is responsible to handle actions from the dynamic config items form
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     */
    async onActionConfigItems(event) {
        switch (event.action) {
            case BaseActionKey.Save:
                await this.configItemsSave(event);
                break;
            case BaseActionKey.Cancel:
                this.configItemsViewMode = ViewMode.Read;
                this.entityConfigItems = this.objectUtility.cloneObject(this.entityConfigItemCopy);
                break;
            case BaseActionKey.Edit:
                this.configItemsViewMode = ViewMode.Edit;
                break;
            default:
                break;
        }
    }
    /**
     * This function is responsible to save a new config item or update an existing one
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     * @private
     */
    async configItemsSave(event) {
        this.configItemsViewMode = ViewMode.Read;
        try {
            this.initForm = false;
            await this.configurationItemsService.updateConfigurationItemsAsync(event.formEntity);
            this.configItemsUserPreferences = this.arrayUtilityService.clone(this.configurationItemsService
                .getConfigurationItemsValue()
                .filter((configItem) => configItem.path === this.configItemUserPath));
            this.assignConfigItemDataToForm();
            this.initForm = true;
        }
        catch (e) { }
    }
}
PrgConfigItemsUserComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigItemsUserComponent, deps: [{ token: i1.AbstractConfigurationItemsService }, { token: i2.ArrayUtilityService }, { token: i3.UtilityService }, { token: i4.TranslateService }, { token: i5.ObjectsUtilityService }, { token: i6.AbstractAuthService }], target: i0.ɵɵFactoryTarget.Component });
PrgConfigItemsUserComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgConfigItemsUserComponent, selector: "prg-config-items-user", inputs: { configItemUserPreferencesDefaultsPath: "configItemUserPreferencesDefaultsPath" }, ngImport: i0, template: "<div class=\"col grid-nogutter px-2 \" *ngIf=\"initForm\">\r\n  <p [ngClass]=\"['text-center' ,'bg-blue-50' ,'text-3xl' ,'border-round', 'mb-2', 'py-3', 'w-full', 'border-300', 'border-1' ,'shadow-1', 'mt-0' ,'text-700']\"  >{{titleForm + '.label'|translate|uppercase}} {{\" : \"+loggedUser?.name|uppercase}}</p>\r\n  <prg-dynamic-form [viewMode]=\"configItemsViewMode\" [actions]=\"configItemsDynamicFormActions\"\r\n                    [fields]=\"configItemsDynamicFormFields\" [entity]=\"entityConfigItems\"\r\n                    (actionOutput)=\"onActionConfigItems($event)\">\r\n  </prg-dynamic-form>\r\n</div>\r\n", styles: [":host ::ng-deep .p-dropdown .p-dropdown-label.p-placeholder{color:#08f}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{width:260px}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{padding-right:.75rem}:host ::ng-deep .p-inputnumber-buttons-stacked .p-inputnumber-input::placeholder{color:#08f!important;font-size:15px}\n"], dependencies: [{ kind: "directive", type: i7.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i8.PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }, { kind: "pipe", type: i7.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i4.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigItemsUserComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-config-items-user', template: "<div class=\"col grid-nogutter px-2 \" *ngIf=\"initForm\">\r\n  <p [ngClass]=\"['text-center' ,'bg-blue-50' ,'text-3xl' ,'border-round', 'mb-2', 'py-3', 'w-full', 'border-300', 'border-1' ,'shadow-1', 'mt-0' ,'text-700']\"  >{{titleForm + '.label'|translate|uppercase}} {{\" : \"+loggedUser?.name|uppercase}}</p>\r\n  <prg-dynamic-form [viewMode]=\"configItemsViewMode\" [actions]=\"configItemsDynamicFormActions\"\r\n                    [fields]=\"configItemsDynamicFormFields\" [entity]=\"entityConfigItems\"\r\n                    (actionOutput)=\"onActionConfigItems($event)\">\r\n  </prg-dynamic-form>\r\n</div>\r\n", styles: [":host ::ng-deep .p-dropdown .p-dropdown-label.p-placeholder{color:#08f}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{width:260px}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{padding-right:.75rem}:host ::ng-deep .p-inputnumber-buttons-stacked .p-inputnumber-input::placeholder{color:#08f!important;font-size:15px}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AbstractConfigurationItemsService }, { type: i2.ArrayUtilityService }, { type: i3.UtilityService }, { type: i4.TranslateService }, { type: i5.ObjectsUtilityService }, { type: i6.AbstractAuthService }]; }, propDecorators: { configItemUserPreferencesDefaultsPath: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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