import { Inject, Injectable } from '@angular/core';
import { firstValueFrom } from 'rxjs';
// import jwt_decode from 'jwt-decode';
import { AbstractAuthService } from './abstract-auth.service';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common/http";
/**
 * Injectable
 */
/**
 * REAL AbstractAuthService implementation
 */
export class AuthService extends AbstractAuthService {
    /**
     * constructor
     * @param {AuthStorage} authStorage
     * @param {HttpClient} http
     */
    constructor(authStorage, http) {
        super(authStorage);
        this.http = http;
        this.baseUrl = 'http://localhost:8080';
    }
    /**
     * User login (Async)
     *
     * @param {string} email The user e-mail
     * @param {string} password The user password
     * @param {boolean} storeUserName Store username
     * @returns Boolean promise, true when successful
     */
    loginAsync(email, password, storeUserName) {
        return firstValueFrom(this.http.get(this.baseUrl));
    }
    /**
     * User logout (Async)
     *
     * @returns Boolean promise, true when successful
     */
    logoutAsync() {
        return new Promise((resolve) => {
            this.setLoggedUser(null);
            resolve(true);
        });
    }
    /**
     * User sign up (Async)
     *
     * @param {string} email The user e-mail
     * @returns Boolean promise, true when successful
     */
    signupAsync(email) {
        throw new Error('Method not implemented.');
    }
    /**
     * Request to reset the password (Async)
     *
     * @param {string} email The user e-mail
     * @returns Boolean promise, true when successful
     */
    requestResetPasswordAsync(email) {
        return Promise.resolve(false);
    }
    /**
     * Getter for token reset password (Async)
     *
     * @param {string} tokenReset The token reset password
     * @returns Boolean promise, true when successful
     */
    getTokenResetPasswordAsync(tokenReset) {
        return Promise.resolve(false);
    }
    /**
     * Method for reset password (Async)
     *
     * @param {string} newPassword The new password
     * @param {string} tokenReset The token reset password
     * @returns Boolean promise, true when successful
     */
    resetPasswordAsync(newPassword, tokenReset) {
        return Promise.resolve(false);
    }
}
AuthService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthService, deps: [{ token: 'AUTHSTORAGE' }, { token: i1.HttpClient }], target: i0.ɵɵFactoryTarget.Injectable });
AuthService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: ['AUTHSTORAGE']
                }] }, { type: i1.HttpClient }]; } });
//# sourceMappingURL=data:application/json;base64,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