import { NgModule } from '@angular/core';
import { PrgSharedComponentsModule } from '../shared-components/shared-components.module';
import { PrgFormLoginComponent } from './components/form-login/prg-form-login.component';
import { PrgFormRegisterComponent } from './components/form-register/prg-form-register.component';
import { PrgFormRequestPasswordComponent } from './components/form-request-password/prg-form-request-password.component';
import { PrgFormResetPasswordComponent } from './components/form-reset-password/prg-form-reset-password.component';
import { MockAuthService } from './mock/services/auth.service.mock';
import { PrgAuthLoginPage } from './pages/login/prg-auth-login.page';
import { PrgAuthRegisterPage } from './pages/register/prg-auth-register.page';
import { PrgAuthRequestPasswordPage } from './pages/request-password/prg-auth-request-password.page';
import { PrgAuthResetPasswordPage } from './pages/reset-password/prg-auth-reset-password.page';
import { PrgAuthRoutingModule } from './prg-auth-routing.module';
import { AbstractAuthService } from './services/auth/abstract-auth.service';
import { AuthService } from './services/auth/auth.service';
import { PRG_AUTH_CONFIG } from './services/prg-auth-configuration/prg-auth-configuration.service';
import * as i0 from "@angular/core";
// CR: falta o multilingue em todo o módulo
/**
 * Module that handles authentication
 */
export class PrgAuthModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgAuthConfig) {
        authConfig = prgAuthConfig;
        return {
            ngModule: PrgAuthModule,
            providers: [
                {
                    provide: PRG_AUTH_CONFIG,
                    useValue: prgAuthConfig,
                },
                {
                    provide: AbstractAuthService,
                    useClass: prgAuthConfig.useMockServices
                        ? MockAuthService
                        : AuthService,
                },
                {
                    provide: 'AUTHSTORAGE',
                    useValue: authConfig.authStorage,
                }, // CR: ok o tipo de storage deve ser uma configuração no environment e o nome que lhe damos deve ser mais generico (ex: "AUTHSTORAGE")
            ],
        };
    }
}
PrgAuthModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgAuthModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthModule, declarations: [PrgAuthRegisterPage,
        PrgFormRegisterComponent,
        PrgAuthLoginPage,
        PrgFormLoginComponent,
        PrgFormRequestPasswordComponent,
        PrgAuthRequestPasswordPage,
        PrgFormResetPasswordComponent,
        PrgAuthResetPasswordPage], imports: [PrgSharedComponentsModule, PrgAuthRoutingModule], exports: [PrgFormRegisterComponent,
        PrgFormLoginComponent,
        PrgFormRequestPasswordComponent,
        PrgFormResetPasswordComponent] });
PrgAuthModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthModule, imports: [PrgSharedComponentsModule, PrgAuthRoutingModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgAuthRegisterPage,
                        PrgFormRegisterComponent,
                        PrgAuthLoginPage,
                        PrgFormLoginComponent,
                        PrgFormRequestPasswordComponent,
                        PrgAuthRequestPasswordPage,
                        PrgFormResetPasswordComponent,
                        PrgAuthResetPasswordPage,
                    ],
                    imports: [PrgSharedComponentsModule, PrgAuthRoutingModule],
                    exports: [
                        PrgFormRegisterComponent,
                        PrgFormLoginComponent,
                        PrgFormRequestPasswordComponent,
                        PrgFormResetPasswordComponent,
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the AuthCoreConfig object
 */
export let authConfig;
//# sourceMappingURL=data:application/json;base64,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