import { NgModule } from '@angular/core';
import { RouterModule, ROUTES } from '@angular/router';
import { PrgLayoutsEmptyComponent } from '../layouts/empty/prg-layouts-empty.component';
import { AuthGuardLogin } from './guards/prg-auth-guard.service';
import { PrgAuthLoginPage } from './pages/login/prg-auth-login.page';
import { PrgAuthRegisterPage } from './pages/register/prg-auth-register.page';
import { PrgAuthRequestPasswordPage } from './pages/request-password/prg-auth-request-password.page';
import { PrgAuthResetPasswordPage } from './pages/reset-password/prg-auth-reset-password.page';
import { authConfig } from './prg-auth.module';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
/**
 * Authentication routing module routes
 */
const standardRoutes = [];
/**
 * Authentication Routing Module
 */
export class PrgAuthRoutingModule {
}
PrgAuthRoutingModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRoutingModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgAuthRoutingModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRoutingModule, imports: [i1.RouterModule], exports: [RouterModule] });
PrgAuthRoutingModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRoutingModule, providers: [
        {
            provide: ROUTES,
            useFactory: () => {
                let routes = [];
                routes.push({
                    path: authConfig.authRoutingBasePath,
                    component: PrgLayoutsEmptyComponent,
                    children: [
                        {
                            path: authConfig.authRoutingSignupPath,
                            component: PrgAuthRegisterPage,
                            canActivate: [AuthGuardLogin],
                        },
                        {
                            path: authConfig.authRoutingLoginPath,
                            component: PrgAuthLoginPage,
                            canActivate: [AuthGuardLogin],
                        },
                        {
                            path: authConfig.authRoutingRequestPasswordPath,
                            component: PrgAuthRequestPasswordPage,
                        },
                        {
                            path: authConfig.authRoutingResetPasswordPath,
                            /*canActivate: [PrgAuthGuardPassword],*/
                            component: PrgAuthResetPasswordPage,
                        },
                        {
                            path: '',
                            redirectTo: authConfig.authRoutingLoginPath,
                            pathMatch: 'full',
                        },
                    ],
                });
                return [...routes, ...standardRoutes];
            },
            multi: true,
        },
    ], imports: [RouterModule.forChild(standardRoutes), RouterModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRoutingModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [RouterModule.forChild(standardRoutes)],
                    exports: [RouterModule],
                    providers: [
                        {
                            provide: ROUTES,
                            useFactory: () => {
                                let routes = [];
                                routes.push({
                                    path: authConfig.authRoutingBasePath,
                                    component: PrgLayoutsEmptyComponent,
                                    children: [
                                        {
                                            path: authConfig.authRoutingSignupPath,
                                            component: PrgAuthRegisterPage,
                                            canActivate: [AuthGuardLogin],
                                        },
                                        {
                                            path: authConfig.authRoutingLoginPath,
                                            component: PrgAuthLoginPage,
                                            canActivate: [AuthGuardLogin],
                                        },
                                        {
                                            path: authConfig.authRoutingRequestPasswordPath,
                                            component: PrgAuthRequestPasswordPage,
                                        },
                                        {
                                            path: authConfig.authRoutingResetPasswordPath,
                                            /*canActivate: [PrgAuthGuardPassword],*/
                                            component: PrgAuthResetPasswordPage,
                                        },
                                        {
                                            path: '',
                                            redirectTo: authConfig.authRoutingLoginPath,
                                            pathMatch: 'full',
                                        },
                                    ],
                                });
                                return [...routes, ...standardRoutes];
                            },
                            multi: true,
                        },
                    ],
                }]
        }] });
//# sourceMappingURL=data:application/json;base64,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