/**
 * Token class that defines some basic JWT
 * <br />properties and adds additional
 * <br />generic properties required by the
 * <br />front-end
 */
export class Token {
    /**
     * Constructor
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
/**
 * PasswordRequirements configuration items model
 * <br />to be used when creating or resetting
 * <br />user passwords
 */
export class PasswordRequirements {
    constructor() {
        /**
         * Gets or sets the minimum length a password must be. Defaults to 6.
         */
        this.requiredLength = 6;
        /**
         * Gets or sets the minimum number of unique characters which a password must contain.
         *<br />Defaults to 1.
         */
        this.requiredUniqueChars = 1;
        /**
         * Gets or sets a flag indicating if passwords must contain a non-alphanumeric character.
         * <br />Defaults to true.
         */
        this.requireNonAlphanumeric = true;
        /**
         * Gets or sets a flag indicating if passwords must contain a lower case ASCII character.
         * <br />Defaults to true.
         */
        this.requireLowercase = true;
        /**
         * Gets or sets a flag indicating if passwords must contain a upper case ASCII character.
         * <br />Defaults to true.
         */
        this.requireUppercase = true;
        /**
         * Gets or sets a flag indicating if passwords must contain a digit.
         * <br />Defaults to true.
         */
        this.requireDigit = true;
    }
}
/**
 * User class that defines the basic properties
 * <br />of an user.
 */
export class User {
    /**
     * Constructor
     * @param {Partial<User>} init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
//# sourceMappingURL=data:application/json;base64,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