import { Injectable } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/auth/abstract-auth.service";
import * as i2 from "@angular/router";
/**
 * Injectable
 */
/**
 * Guard to verify if there is a logged user. If true, user can't access login page and register page.
 */
export class AuthGuardLogin {
    /**
     * constructor
     * @param authService
     * @param router
     */
    constructor(authService, router) {
        this.authService = authService;
        this.router = router;
    }
    /**
     *  This method is responsable to check if there is a user logged on local storage and return true if not or redirect user to home page if there is a user logged
     * @param {ActivatedRouteSnapshot} route
     * @param {RouterStateSnapshot} state
     * @returns {Observable<boolean | UrlTree> | Promise<boolean | UrlTree> | boolean | UrlTree}
     */
    canActivate(route, state) {
        if (!this.authService.getLoggedUser()) {
            return true;
        }
        else {
            return this.router.createUrlTree(['']);
        }
    }
}
AuthGuardLogin.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthGuardLogin, deps: [{ token: i1.AbstractAuthService }, { token: i2.Router }], target: i0.ɵɵFactoryTarget.Injectable });
AuthGuardLogin.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthGuardLogin, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthGuardLogin, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i1.AbstractAuthService }, { type: i2.Router }]; } });
//# sourceMappingURL=data:application/json;base64,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