import { Component, Inject, Input } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { PasswordRequirements } from '../../models/user.model';
import { PRG_AUTH_CONFIG } from '../../services/prg-auth-configuration/prg-auth-configuration.service';
import { PrgAuthCustomPasswordRequirements } from '../../validators/custom-password-requirements/prg-auth-custom-password-requirements';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "ngx-logger";
import * as i3 from "../../services/auth/abstract-auth.service";
import * as i4 from "primeng/api";
import * as i5 from "../../models/user.model";
import * as i6 from "../../../core/services/is-loading-data/isloadingdata.service";
import * as i7 from "primeng/inputtext";
import * as i8 from "@angular/common";
import * as i9 from "primeng/button";
import * as i10 from "primeng/ripple";
import * as i11 from "@angular/forms";
import * as i12 from "@ngx-translate/core";
/**
 * The form reset password component
 */
export class PrgFormResetPasswordComponent {
    /**
     * Constructor
     * @param route
     * @param router
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param passwordRequirements passwordRequirements
     * @param isLoadingData isLoadingData
     */
    constructor(route, router, logger, authService, primengConfig, authRoutes, passwordRequirements, isLoadingData) {
        this.route = route;
        this.router = router;
        this.logger = logger;
        this.authService = authService;
        this.primengConfig = primengConfig;
        this.authRoutes = authRoutes;
        this.passwordRequirements = passwordRequirements;
        this.isLoadingData = isLoadingData;
        /**
         * The route for login page
         */
        this.loginPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingLoginPath;
        /**
         * Shows/hide the login link.  Default true.
         */
        this.showLoginLink = true;
        /**
         * Shows/hide password on form. Default false.
         */
        this.showPassword = false;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('RESET PASSWORD FORM ON INIT');
        this.token = this.route.snapshot.queryParams['token'];
        if (this.token == null || this.token.length === 0) {
            this.router.navigate([this.loginPageRoute]);
        }
        /*This observable is used when is necessary to reload the component within the same component*/
        this.queryParamsSubscription = this.route.queryParams.subscribe((queryParams) => {
            this.token = queryParams['token'];
        });
        this.initFormResetPassword();
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('RESET PASSWORD FORM ON DESTROY');
        this.queryParamsSubscription.unsubscribe();
    }
    /**
     * Initiate the reset password form and its form controls with validators
     */
    initFormResetPassword() {
        this.resetPasswordForm = new FormGroup({
            password: new FormControl(null, [
                Validators.required,
                Validators.minLength(this.passwordRequirements.requiredLength),
                PrgAuthCustomPasswordRequirements.patternValidator(/\d/, {
                    hasNumber: true,
                }, this.passwordRequirements.requireDigit),
                PrgAuthCustomPasswordRequirements.patternValidator(/[a-z]/, {
                    hasSmallCase: true,
                }, this.passwordRequirements.requireLowercase),
                PrgAuthCustomPasswordRequirements.patternValidator(/[A-Z]/, {
                    hasCapitalCase: true,
                }, this.passwordRequirements.requireUppercase),
                PrgAuthCustomPasswordRequirements.patternValidator(/[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/, {
                    hasSpecialCharacters: true,
                }, this.passwordRequirements.requireNonAlphanumeric),
                PrgAuthCustomPasswordRequirements.uniqueCharsValidator(this.passwordRequirements.requiredUniqueChars, {
                    numberOfUniqueChars: this.passwordRequirements.requiredUniqueChars,
                }),
            ]),
            confirmPassword: new FormControl(null, [Validators.required]),
        }, {
            validators: PrgAuthCustomPasswordRequirements.passwordMatchValidator,
            updateOn: 'change',
        });
    }
    /**
     * Function to display/hide password on click
     */
    onShowPassword() {
        this.showPassword = !this.showPassword;
    }
    /**
     * Form submission
     */
    async onSubmitResetPassword() {
        if (this.resetPasswordForm.invalid) {
            return;
        }
        const userNewPassword = this.resetPasswordForm.controls.password.value;
        this.resetPasswordForm.disable();
        try {
            if (await this.authService.resetPasswordAsync(userNewPassword, this.token)) {
                this.resetPasswordForm.reset();
                this.router.navigate([this.loginPageRoute]);
            }
        }
        catch (error) {
            this.logger.debug(error);
        }
        this.resetPasswordForm.enable();
    }
}
PrgFormResetPasswordComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormResetPasswordComponent, deps: [{ token: i1.ActivatedRoute }, { token: i1.Router }, { token: i2.NGXLogger }, { token: i3.AbstractAuthService }, { token: i4.PrimeNGConfig }, { token: PRG_AUTH_CONFIG }, { token: i5.PasswordRequirements }, { token: i6.IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Component });
PrgFormResetPasswordComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgFormResetPasswordComponent, selector: "prg-form-reset-password", inputs: { loginPageRoute: "loginPageRoute", showLoginLink: "showLoginLink" }, providers: [PasswordRequirements], ngImport: i0, template: "<div class=\"flex justify-content-center\">\r\n<div class=\"mainContainer shadow-3  border-1 border-300 surface-card border-round-lg w-28rem\">\r\n  <form [formGroup]=\"resetPasswordForm\" (ngSubmit)=\"onSubmitResetPassword()\" novalidate>\r\n    <div class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 my-4 text-center\">{{'components.reset-password.title'|translate|uppercase}}\r\n    </div>\r\n    <div class=\"px-5 mb-3\">\r\n      <h6 class=\"text-700\">{{'components.reset-password.new-password.label'|translate}}</h6>\r\n      <span class=\"p-input-icon-left w-full \"><i class=\"pi pi-lock\" (click)=\"onShowPassword()\"\r\n                                                 style=\"cursor: pointer\"></i>\r\n              <input placeholder=\"{{'components.reset-password.new-password.placeholder'|translate}}\" formControlName=\"password\" autofocus id=\"password\"\r\n                     autocomplete=\"new-password\"\r\n                     [type]=\"showPassword?'text':'password'\" class=\"w-full\"\r\n                     pInputText></span>\r\n      <div class=\"flex flex-column mt-2\"\r\n           *ngIf=\"resetPasswordForm.controls.password.touched&&resetPasswordForm.controls.password.dirty\">\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.password.hasError('required')\">Password is\r\n          required.</small>\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasCapitalCase')\">Password\r\n          must have\r\n          one upper case.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasSmallCase')\">Password must have\r\n          one lower\r\n          case.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasNumber')\">Password must have one\r\n          number.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('minlength')\">Password must\r\n          have {{this.passwordRequirements.requiredLength}} chars in length.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasSpecialCharacters')\">Password\r\n          must have\r\n          one special char.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('numberOfUniqueChars')\">Password must\r\n          have {{this.passwordRequirements.requiredUniqueChars}} unique chars.</small>\r\n      </div>\r\n    </div>\r\n    <div class=\"px-5 mb-5\">\r\n      <h6 class=\"text-700\">{{'components.reset-password.new-password-confirmation.label'|translate}}</h6>\r\n      <span class=\"p-input-icon-left w-full \"><i class=\"pi pi-lock\" (click)=\"onShowPassword()\"\r\n                                                 style=\"cursor: pointer\"></i>\r\n              <input placeholder=\"{{'components.reset-password.new-password-confirmation.placeholder'|translate}}\" formControlName=\"confirmPassword\" id=\"confirmPassword\"\r\n                     autocomplete=\"new-password\"\r\n                     [type]=\"showPassword?'text':'password'\" class=\"w-full\"\r\n                     pInputText></span>\r\n\r\n      <div class=\"flex flex-column mt-2\"\r\n           *ngIf=\"resetPasswordForm.controls.confirmPassword.touched&&resetPasswordForm.controls.confirmPassword.dirty\">\r\n\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.confirmPassword.hasError('required')\">Confirm\r\n          Password is\r\n          required.</small>\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.hasError('passDontMatch')\">Password and\r\n          confirm password do not match</small>\r\n      </div>\r\n    </div>\r\n    <div class=\"px-5 mb-3 text-center\">\r\n      <button type=\"submit\" [disabled]=\"!resetPasswordForm.valid||(isLoadingData.visibility|async)\" pButton pRipple\r\n              label=\"{{'components.reset-password.button.label'|translate}}\"\r\n              icon=\"pi pi-unlock\"\r\n              class=\"w-full\"></button>\r\n    </div>\r\n    <div class=\"px-5 mb-3  text-center\" *ngIf=\"showLoginLink\">\r\n      <a [style.pointer-events]=\"(isLoadingData.visibility|async)?'none':'auto'\"  routerLink=\"{{loginPageRoute}}\"\r\n         class=\"underlineEffect text-sm blue-500 font-medium cursor-pointer\"\r\n         style=\"text-decoration: none\">{{'components.request-password.login-link.label'|translate}}</a>\r\n    </div>\r\n\r\n  </form>\r\n</div>\r\n</div>\r\n\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"], dependencies: [{ kind: "directive", type: i1.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i7.InputText, selector: "[pInputText]" }, { kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i9.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i10.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i11.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i11.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i11.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i11.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i11.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i11.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i8.AsyncPipe, name: "async" }, { kind: "pipe", type: i8.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i12.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormResetPasswordComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-form-reset-password', providers: [PasswordRequirements], template: "<div class=\"flex justify-content-center\">\r\n<div class=\"mainContainer shadow-3  border-1 border-300 surface-card border-round-lg w-28rem\">\r\n  <form [formGroup]=\"resetPasswordForm\" (ngSubmit)=\"onSubmitResetPassword()\" novalidate>\r\n    <div class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 my-4 text-center\">{{'components.reset-password.title'|translate|uppercase}}\r\n    </div>\r\n    <div class=\"px-5 mb-3\">\r\n      <h6 class=\"text-700\">{{'components.reset-password.new-password.label'|translate}}</h6>\r\n      <span class=\"p-input-icon-left w-full \"><i class=\"pi pi-lock\" (click)=\"onShowPassword()\"\r\n                                                 style=\"cursor: pointer\"></i>\r\n              <input placeholder=\"{{'components.reset-password.new-password.placeholder'|translate}}\" formControlName=\"password\" autofocus id=\"password\"\r\n                     autocomplete=\"new-password\"\r\n                     [type]=\"showPassword?'text':'password'\" class=\"w-full\"\r\n                     pInputText></span>\r\n      <div class=\"flex flex-column mt-2\"\r\n           *ngIf=\"resetPasswordForm.controls.password.touched&&resetPasswordForm.controls.password.dirty\">\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.password.hasError('required')\">Password is\r\n          required.</small>\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasCapitalCase')\">Password\r\n          must have\r\n          one upper case.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasSmallCase')\">Password must have\r\n          one lower\r\n          case.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasNumber')\">Password must have one\r\n          number.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('minlength')\">Password must\r\n          have {{this.passwordRequirements.requiredLength}} chars in length.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasSpecialCharacters')\">Password\r\n          must have\r\n          one special char.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('numberOfUniqueChars')\">Password must\r\n          have {{this.passwordRequirements.requiredUniqueChars}} unique chars.</small>\r\n      </div>\r\n    </div>\r\n    <div class=\"px-5 mb-5\">\r\n      <h6 class=\"text-700\">{{'components.reset-password.new-password-confirmation.label'|translate}}</h6>\r\n      <span class=\"p-input-icon-left w-full \"><i class=\"pi pi-lock\" (click)=\"onShowPassword()\"\r\n                                                 style=\"cursor: pointer\"></i>\r\n              <input placeholder=\"{{'components.reset-password.new-password-confirmation.placeholder'|translate}}\" formControlName=\"confirmPassword\" id=\"confirmPassword\"\r\n                     autocomplete=\"new-password\"\r\n                     [type]=\"showPassword?'text':'password'\" class=\"w-full\"\r\n                     pInputText></span>\r\n\r\n      <div class=\"flex flex-column mt-2\"\r\n           *ngIf=\"resetPasswordForm.controls.confirmPassword.touched&&resetPasswordForm.controls.confirmPassword.dirty\">\r\n\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.confirmPassword.hasError('required')\">Confirm\r\n          Password is\r\n          required.</small>\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.hasError('passDontMatch')\">Password and\r\n          confirm password do not match</small>\r\n      </div>\r\n    </div>\r\n    <div class=\"px-5 mb-3 text-center\">\r\n      <button type=\"submit\" [disabled]=\"!resetPasswordForm.valid||(isLoadingData.visibility|async)\" pButton pRipple\r\n              label=\"{{'components.reset-password.button.label'|translate}}\"\r\n              icon=\"pi pi-unlock\"\r\n              class=\"w-full\"></button>\r\n    </div>\r\n    <div class=\"px-5 mb-3  text-center\" *ngIf=\"showLoginLink\">\r\n      <a [style.pointer-events]=\"(isLoadingData.visibility|async)?'none':'auto'\"  routerLink=\"{{loginPageRoute}}\"\r\n         class=\"underlineEffect text-sm blue-500 font-medium cursor-pointer\"\r\n         style=\"text-decoration: none\">{{'components.request-password.login-link.label'|translate}}</a>\r\n    </div>\r\n\r\n  </form>\r\n</div>\r\n</div>\r\n\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.ActivatedRoute }, { type: i1.Router }, { type: i2.NGXLogger }, { type: i3.AbstractAuthService }, { type: i4.PrimeNGConfig }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: i5.PasswordRequirements }, { type: i6.IsLoadingDataService }]; }, propDecorators: { loginPageRoute: [{
                type: Input
            }], showLoginLink: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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