import { Component, Inject, Input } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { PRG_AUTH_CONFIG } from '../../services/prg-auth-configuration/prg-auth-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "ngx-logger";
import * as i2 from "../../services/auth/abstract-auth.service";
import * as i3 from "primeng/api";
import * as i4 from "../../../core/services/is-loading-data/isloadingdata.service";
import * as i5 from "@angular/router";
import * as i6 from "primeng/inputtext";
import * as i7 from "@angular/common";
import * as i8 from "primeng/button";
import * as i9 from "primeng/ripple";
import * as i10 from "@angular/forms";
import * as i11 from "@ngx-translate/core";
/**
 * The form request password component
 */
export class PrgFormRequestPasswordComponent {
    /**
     * constructor
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param isLoadingData isLoadingData
     */
    constructor(logger, authService, primengConfig, authRoutes, isLoadingData) {
        this.logger = logger;
        this.authService = authService;
        this.primengConfig = primengConfig;
        this.authRoutes = authRoutes;
        this.isLoadingData = isLoadingData;
        /**
         * Shows/hide the login link.  Default true.
         */
        this.showLoginLink = true;
        /**
         * The default route for login page
         */
        this.loginPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingLoginPath;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('REQUEST PASSWORD PAGE ON INIT');
        this.primengConfig.ripple = true;
        this.initFormRequestPass();
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('REQUEST PASSWORD PAGE ON DESTROY');
    }
    /**
     * Initiate the request password form and its form controls with validators
     */
    initFormRequestPass() {
        this.requestPassForm = new FormGroup({
            email: new FormControl(null, [Validators.required, Validators.email]),
        }, { updateOn: 'change' });
    }
    /**
     * Form submission
     */
    async onSubmitRequestPassword() {
        if (this.requestPassForm.invalid) {
            return;
        }
        const userEmail = this.requestPassForm.controls.email.value;
        this.requestPassForm.disable();
        try {
            if (await this.authService.requestResetPasswordAsync(userEmail)) {
                this.requestPassForm.reset();
                // TODO: Falta reencaminhar o user após pedido do reset da password .Rota??
            }
        }
        catch (error) {
            this.logger.debug(error);
        }
        this.requestPassForm.enable();
    }
}
PrgFormRequestPasswordComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormRequestPasswordComponent, deps: [{ token: i1.NGXLogger }, { token: i2.AbstractAuthService }, { token: i3.PrimeNGConfig }, { token: PRG_AUTH_CONFIG }, { token: i4.IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Component });
PrgFormRequestPasswordComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgFormRequestPasswordComponent, selector: "prg-form-request-password", inputs: { showLoginLink: "showLoginLink", loginPageRoute: "loginPageRoute" }, ngImport: i0, template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form\r\n      [formGroup]=\"requestPassForm\"\r\n      (ngSubmit)=\"onSubmitRequestPassword()\"\r\n      novalidate\r\n    >\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 my-4 text-center\"\r\n      >\r\n        {{ 'components.request-password.title' | translate | uppercase }}\r\n      </div>\r\n      <div class=\"px-5 mb-5\">\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.email.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autofocus\r\n            autocomplete=\"email\"\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n      </div>\r\n      <div class=\"px-5 text-center mb-3\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"\r\n            !requestPassForm.valid || (isLoadingData.visibility | async)\r\n          \"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.request-password.button.label' | translate }}\"\r\n          icon=\"pi pi-lock\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showLoginLink\">\r\n        <a\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          routerLink=\"{{ loginPageRoute }}\"\r\n          class=\"underlineEffect text-sm blue-500 font-medium cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.request-password.login-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"], dependencies: [{ kind: "directive", type: i5.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i9.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i10.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i10.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i10.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i10.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i10.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i10.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i7.AsyncPipe, name: "async" }, { kind: "pipe", type: i7.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i11.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormRequestPasswordComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-form-request-password', template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form\r\n      [formGroup]=\"requestPassForm\"\r\n      (ngSubmit)=\"onSubmitRequestPassword()\"\r\n      novalidate\r\n    >\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 my-4 text-center\"\r\n      >\r\n        {{ 'components.request-password.title' | translate | uppercase }}\r\n      </div>\r\n      <div class=\"px-5 mb-5\">\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.email.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autofocus\r\n            autocomplete=\"email\"\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n      </div>\r\n      <div class=\"px-5 text-center mb-3\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"\r\n            !requestPassForm.valid || (isLoadingData.visibility | async)\r\n          \"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.request-password.button.label' | translate }}\"\r\n          icon=\"pi pi-lock\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showLoginLink\">\r\n        <a\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          routerLink=\"{{ loginPageRoute }}\"\r\n          class=\"underlineEffect text-sm blue-500 font-medium cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.request-password.login-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }, { type: i2.AbstractAuthService }, { type: i3.PrimeNGConfig }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: i4.IsLoadingDataService }]; }, propDecorators: { showLoginLink: [{
                type: Input
            }], loginPageRoute: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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