import { Component, Inject, Input } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { PRG_AUTH_CONFIG } from '../../services/prg-auth-configuration/prg-auth-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "ngx-logger";
import * as i2 from "../../services/auth/abstract-auth.service";
import * as i3 from "primeng/api";
import * as i4 from "../../../core/services/is-loading-data/isloadingdata.service";
import * as i5 from "@angular/router";
import * as i6 from "primeng/inputtext";
import * as i7 from "@angular/common";
import * as i8 from "primeng/button";
import * as i9 from "primeng/checkbox";
import * as i10 from "primeng/image";
import * as i11 from "primeng/ripple";
import * as i12 from "@angular/forms";
import * as i13 from "@ngx-translate/core";
/**
 * Form Register Component
 */
export class PrgFormRegisterComponent {
    /**
     * Constructor
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param isLoadingData isLoadingData
     */
    constructor(logger, authService, primengConfig, authRoutes, isLoadingData) {
        this.logger = logger;
        this.authService = authService;
        this.primengConfig = primengConfig;
        this.authRoutes = authRoutes;
        this.isLoadingData = isLoadingData;
        /**
         * Shows/hide the checkbox terms of use. Default true.
         */
        this.showTermsOfUse = true;
        /**
         * Shows/hide the login link.  Default true.
         */
        this.showLoginLink = true;
        /**
         * The route for login page
         */
        this.loginPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingLoginPath;
        /**
         * The route for terms of use page
         */
        this.termsOfUsePageRoute = '/' + this.authRoutes.termsOfUseRoutingPath;
        /**
         * Property of the class with type string which bind to image logo form.
         */
        this.imagePathLogo = '';
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('REGISTER FORM ON INIT');
        this.primengConfig.ripple = true;
        this.initFormRegister();
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('REGISTER FORM ON DESTROY');
    }
    /**
     * Initiate the register form and its form controls with validators
     */
    initFormRegister() {
        this.registerForm = new FormGroup({
            email: new FormControl(null, [Validators.required, Validators.email]),
            termsOfUse: new FormControl(null, [Validators.requiredTrue]),
        }, { updateOn: 'change' });
        if (!this.showTermsOfUse) {
            this.registerForm.controls.termsOfUse.removeValidators(Validators.requiredTrue);
        }
    }
    /**
     * Form submission
     */
    async onSubmitRegister() {
        if (this.registerForm.invalid) {
            return;
        }
        const userEmail = this.registerForm.controls.email.value;
        this.registerForm.disable();
        try {
            if (await this.authService.signupAsync(userEmail)) {
                this.registerForm.reset();
                // TODO: Falta reencaminhar o user após sucesso no registo .Rota??
            }
        }
        catch (error) {
            this.logger.debug(error);
        }
        this.registerForm.enable();
    }
}
PrgFormRegisterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormRegisterComponent, deps: [{ token: i1.NGXLogger }, { token: i2.AbstractAuthService }, { token: i3.PrimeNGConfig }, { token: PRG_AUTH_CONFIG }, { token: i4.IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Component });
PrgFormRegisterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgFormRegisterComponent, selector: "prg-form-register", inputs: { showTermsOfUse: "showTermsOfUse", showLoginLink: "showLoginLink", loginPageRoute: "loginPageRoute", termsOfUsePageRoute: "termsOfUsePageRoute", imagePathLogo: "imagePathLogo" }, ngImport: i0, template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form [formGroup]=\"registerForm\" (ngSubmit)=\"onSubmitRegister()\" novalidate>\r\n      <div\r\n        class=\"text-center\"\r\n        [class]=\"{ 'my-3': imagePathLogo, 'my-1': !imagePathLogo }\"\r\n      >\r\n        <p-image [src]=\"imagePathLogo\" class=\"w-8\" alt=\"\"></p-image>\r\n      </div>\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 mb-4 text-center\"\r\n      >\r\n        {{ 'components.register.title' | translate | uppercase }}\r\n      </div>\r\n      <div\r\n        class=\"px-5\"\r\n        [class]=\"{ 'mb-3': showTermsOfUse, 'mb-4': !showTermsOfUse }\"\r\n      >\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.email.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autofocus\r\n            autocomplete=\"email\"\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            registerForm.controls.email.touched &&\r\n            registerForm.controls.email.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"registerForm.controls.email.hasError('required')\"\r\n            >Email is required.</small\r\n          >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"registerForm.controls.email.hasError('email')\"\r\n            >Email is not valid.</small\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"flex align-items-center px-5 mb-4\" *ngIf=\"showTermsOfUse\">\r\n        <div class=\"field-checkbox\">\r\n          <p-checkbox\r\n            formControlName=\"termsOfUse\"\r\n            [binary]=\"true\"\r\n            inputId=\"termsOfUse\"\r\n          ></p-checkbox>\r\n          <label for=\"termsOfUse\" class=\"text-600 text-sm\">{{\r\n            'components.register.agree-terms.label' | translate\r\n          }}</label>\r\n          <a\r\n            [style.pointer-events]=\"\r\n              (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n            \"\r\n            routerLink=\"{{ termsOfUsePageRoute }}\"\r\n            class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n            style=\"text-decoration: none\"\r\n            >{{ 'components.register.terms-link.label' | translate }}</a\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"px-5 mb-4 text-center\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"!registerForm.valid || (isLoadingData.visibility | async)\"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.register.button.label' | translate }}\"\r\n          icon=\"pi pi-user\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showLoginLink\">\r\n        <label class=\"text-600 text-sm\">{{\r\n          'components.register.question-account.label' | translate\r\n        }}</label>\r\n        <a\r\n          routerLink=\"{{ loginPageRoute }}\"\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.register.login-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"], dependencies: [{ kind: "directive", type: i5.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i9.Checkbox, selector: "p-checkbox", inputs: ["value", "name", "disabled", "binary", "label", "ariaLabelledBy", "ariaLabel", "tabindex", "inputId", "style", "styleClass", "labelStyleClass", "formControl", "checkboxIcon", "readonly", "required", "trueValue", "falseValue"], outputs: ["onChange"] }, { kind: "component", type: i10.Image, selector: "p-image", inputs: ["imageClass", "imageStyle", "styleClass", "style", "src", "alt", "width", "height", "appendTo", "preview", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide", "onImageError"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i12.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i12.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i12.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i12.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i12.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i12.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i7.AsyncPipe, name: "async" }, { kind: "pipe", type: i7.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i13.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormRegisterComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-form-register', template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form [formGroup]=\"registerForm\" (ngSubmit)=\"onSubmitRegister()\" novalidate>\r\n      <div\r\n        class=\"text-center\"\r\n        [class]=\"{ 'my-3': imagePathLogo, 'my-1': !imagePathLogo }\"\r\n      >\r\n        <p-image [src]=\"imagePathLogo\" class=\"w-8\" alt=\"\"></p-image>\r\n      </div>\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 mb-4 text-center\"\r\n      >\r\n        {{ 'components.register.title' | translate | uppercase }}\r\n      </div>\r\n      <div\r\n        class=\"px-5\"\r\n        [class]=\"{ 'mb-3': showTermsOfUse, 'mb-4': !showTermsOfUse }\"\r\n      >\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.email.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autofocus\r\n            autocomplete=\"email\"\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            registerForm.controls.email.touched &&\r\n            registerForm.controls.email.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"registerForm.controls.email.hasError('required')\"\r\n            >Email is required.</small\r\n          >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"registerForm.controls.email.hasError('email')\"\r\n            >Email is not valid.</small\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"flex align-items-center px-5 mb-4\" *ngIf=\"showTermsOfUse\">\r\n        <div class=\"field-checkbox\">\r\n          <p-checkbox\r\n            formControlName=\"termsOfUse\"\r\n            [binary]=\"true\"\r\n            inputId=\"termsOfUse\"\r\n          ></p-checkbox>\r\n          <label for=\"termsOfUse\" class=\"text-600 text-sm\">{{\r\n            'components.register.agree-terms.label' | translate\r\n          }}</label>\r\n          <a\r\n            [style.pointer-events]=\"\r\n              (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n            \"\r\n            routerLink=\"{{ termsOfUsePageRoute }}\"\r\n            class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n            style=\"text-decoration: none\"\r\n            >{{ 'components.register.terms-link.label' | translate }}</a\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"px-5 mb-4 text-center\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"!registerForm.valid || (isLoadingData.visibility | async)\"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.register.button.label' | translate }}\"\r\n          icon=\"pi pi-user\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showLoginLink\">\r\n        <label class=\"text-600 text-sm\">{{\r\n          'components.register.question-account.label' | translate\r\n        }}</label>\r\n        <a\r\n          routerLink=\"{{ loginPageRoute }}\"\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.register.login-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }, { type: i2.AbstractAuthService }, { type: i3.PrimeNGConfig }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: i4.IsLoadingDataService }]; }, propDecorators: { showTermsOfUse: [{
                type: Input
            }], showLoginLink: [{
                type: Input
            }], loginPageRoute: [{
                type: Input
            }], termsOfUsePageRoute: [{
                type: Input
            }], imagePathLogo: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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