import { Component, Inject, Input } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { PRG_AUTH_CONFIG } from '../../services/prg-auth-configuration/prg-auth-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "ngx-logger";
import * as i2 from "../../services/auth/abstract-auth.service";
import * as i3 from "primeng/api";
import * as i4 from "@angular/router";
import * as i5 from "../../../core/services/is-loading-data/isloadingdata.service";
import * as i6 from "primeng/inputtext";
import * as i7 from "@angular/common";
import * as i8 from "primeng/button";
import * as i9 from "primeng/checkbox";
import * as i10 from "primeng/image";
import * as i11 from "primeng/ripple";
import * as i12 from "@angular/forms";
import * as i13 from "@ngx-translate/core";
/**
 * Form Login Component
 */
export class PrgFormLoginComponent {
    // GCR: strings devem ser pelicas ('') em vez de aspas (""). está configurad no pretier devemos correr um comando para correr o pretier em todos os ficheiros
    /**
     * constructor
     * @param {NGXLogger} logger logger
     * @param {AbstractAuthService} authService authService
     * @param {PrimeNGConfig} primengConfig
     * @param {PrgAuthConfig} authRoutes
     * @param {Router} router
     * @param {IsLoadingDataService} isLoadingData isLoadingData
     */
    constructor(logger, authService, primengConfig, authRoutes, // GCR: usar sempre o authConfig diretamente sem DI | Resp : Dá um erro de dependencia circular ao utilizar o authConfig
    router, isLoadingData) {
        this.logger = logger;
        this.authService = authService;
        this.primengConfig = primengConfig;
        this.authRoutes = authRoutes;
        this.router = router;
        this.isLoadingData = isLoadingData;
        /**
         * Shows/hide the checkbox to save username on local storage. Default true.
         */
        this.showStoreUserName = true;
        /**
         * Shows/hide the reset password link.  Default true.
         */
        this.showResetPasswordLink = true;
        /**
         * Shows/hide sign up link.  Default true.
         */
        this.showSignUpRoute = true;
        /**
         * The route for signup page
         */
        this.signUpPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingSignupPath;
        /**
         * The route to redirect after login success
         */
        this.loginOkRedirectLink = '/' + this.authRoutes.authRoutingLoginOkRedirectPath;
        /**
         * The route for request new password
         */
        this.resetPasswordPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingRequestPasswordPath;
        /**
         * Property of the class with type string which bind to image logo form.
         */
        this.imagePathLogo = '';
        /**
         * Shows/hide password on form. Default false.
         */
        this.showPassword = false;
        /**
         * Property of the class with type boolean which bind to the checkbox "Remember me"
         */
        this.checkedStoreUserName = false;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('LOGIN FORM ON INIT');
        this.initFormLogin();
        this.authService.getStoredUserNameObservable().subscribe((userEmail) => {
            if (userEmail) {
                this.loginForm.controls['email'].setValue(userEmail);
                this.checkedStoreUserName = true;
            }
        });
        this.primengConfig.ripple = true;
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('LOGIN FORM ON DESTROY');
    }
    /**
     * Initiate the login form and its form controls with validators
     */
    initFormLogin() {
        this.loginForm = new FormGroup({
            email: new FormControl(null, [Validators.required]),
            check: new FormControl(),
            password: new FormControl(null, [Validators.required]),
            storeUserName: new FormControl(null),
        }, { updateOn: 'change' });
    }
    /**
     * Show/Hide the password on login form
     */
    onShowPassword() {
        this.showPassword = !this.showPassword;
    }
    /**
     * Form submission
     */
    async onSubmitLogin() {
        if (this.loginForm.invalid) {
            return;
        }
        const userEmail = this.loginForm.controls.email.value;
        const userPassword = this.loginForm.controls.password.value;
        const storeUserName = this.loginForm.controls.storeUserName.value;
        this.loginForm.disable();
        try {
            if (await this.authService.loginAsync(userEmail, userPassword, storeUserName)) {
                this.loginForm.reset();
                await this.router.navigate([this.loginOkRedirectLink]);
            }
        }
        catch (error) {
            this.logger.debug(error);
        }
        this.loginForm.enable();
    }
}
PrgFormLoginComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormLoginComponent, deps: [{ token: i1.NGXLogger }, { token: i2.AbstractAuthService }, { token: i3.PrimeNGConfig }, { token: PRG_AUTH_CONFIG }, { token: i4.Router }, { token: i5.IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Component });
PrgFormLoginComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgFormLoginComponent, selector: "prg-form-login", inputs: { showStoreUserName: "showStoreUserName", showResetPasswordLink: "showResetPasswordLink", showSignUpRoute: "showSignUpRoute", signUpPageRoute: "signUpPageRoute", loginOkRedirectLink: "loginOkRedirectLink", resetPasswordPageRoute: "resetPasswordPageRoute", imagePathLogo: "imagePathLogo" }, ngImport: i0, template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form\r\n      [formGroup]=\"loginForm\"\r\n      (ngSubmit)=\"onSubmitLogin()\"\r\n      novalidate\r\n      autocomplete=\"off\"\r\n    >\r\n      <div\r\n        class=\"text-center\"\r\n        [class]=\"{ 'my-3': imagePathLogo, 'my-1': !imagePathLogo }\"\r\n      >\r\n        <p-image [src]=\"imagePathLogo\" class=\"w-8\" alt=\"\"></p-image>\r\n      </div>\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 mb-4 text-center\"\r\n      >\r\n        {{ 'components.login.title' | translate | uppercase }}\r\n      </div>\r\n      <div class=\"px-5 mb-4\">\r\n        <h6 class=\"text-700\">\r\n          {{\r\n            ('entities.user.fields.email.label' | translate) +\r\n              ' ou ' +\r\n              ('entities.user.fields.token.unique_name.label'\r\n                | translate\r\n                | lowercase)\r\n          }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) +\r\n                ' ou ' +\r\n                ('entities.user.fields.token.unique_name.label'\r\n                  | translate\r\n                  | lowercase) +\r\n                '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autocomplete=\"off\"\r\n            autofocus\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n            [defaultValue]=\"authService.getStoredUserName()\"\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            loginForm.controls.email.touched && loginForm.controls.email.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"loginForm.controls.email.hasError('required')\"\r\n            >Email or username is required.</small\r\n          >\r\n        </div>\r\n      </div>\r\n      <div\r\n        class=\"px-5\"\r\n        [class]=\"{\r\n          'mb-3': showStoreUserName && showResetPasswordLink,\r\n          'mb-4': !showStoreUserName || !showResetPasswordLink\r\n        }\"\r\n      >\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.password.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i\r\n            class=\"pi pi-lock\"\r\n            (click)=\"onShowPassword()\"\r\n            style=\"cursor: pointer\"\r\n          ></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.password.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"password\"\r\n            id=\"password\"\r\n            autocomplete=\"off\"\r\n            [type]=\"showPassword ? 'text' : 'password'\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            loginForm.controls.password.touched &&\r\n            loginForm.controls.password.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"loginForm.controls.password.hasError('required')\"\r\n            >Password is required.</small\r\n          >\r\n        </div>\r\n      </div>\r\n\r\n      <div class=\"flex justify-content-between flex-wrap px-5 mb-4\">\r\n        <div\r\n          class=\"field-checkbox flex align-items-center justify-content-center\"\r\n          *ngIf=\"showStoreUserName\"\r\n        >\r\n          <p-checkbox\r\n            [(ngModel)]=\"checkedStoreUserName\"\r\n            formControlName=\"storeUserName\"\r\n            [binary]=\"true\"\r\n            inputId=\"storeUserName\"\r\n          ></p-checkbox>\r\n          <label for=\"storeUserName\" class=\"text-600 text-sm\">{{\r\n            'components.login.remember-me.label' | translate\r\n          }}</label>\r\n        </div>\r\n        <div\r\n          class=\"field flex align-items-center justify-content-center\"\r\n          *ngIf=\"showResetPasswordLink\"\r\n        >\r\n          <a\r\n            [style.pointer-events]=\"\r\n              (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n            \"\r\n            routerLink=\"{{\r\n              !(isLoadingData.visibility | async) ? resetPasswordPageRoute : ''\r\n            }}\"\r\n            class=\"underlineEffect text-sm blue-500 font-medium ml-1 cursor-pointer\"\r\n            style=\"text-decoration: none\"\r\n            >{{ 'components.login.forget-password-link.label' | translate }}</a\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"!loginForm.valid || (isLoadingData.visibility | async)\"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.login.button.label' | translate }}\"\r\n          icon=\"pi pi-unlock\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showSignUpRoute\">\r\n        <label class=\"text-600 text-sm\">{{\r\n          'components.login.question-account.label' | translate\r\n        }}</label>\r\n        <a\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          routerLink=\"{{ signUpPageRoute }}\"\r\n          class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.login.signup-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"], dependencies: [{ kind: "directive", type: i4.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i9.Checkbox, selector: "p-checkbox", inputs: ["value", "name", "disabled", "binary", "label", "ariaLabelledBy", "ariaLabel", "tabindex", "inputId", "style", "styleClass", "labelStyleClass", "formControl", "checkboxIcon", "readonly", "required", "trueValue", "falseValue"], outputs: ["onChange"] }, { kind: "component", type: i10.Image, selector: "p-image", inputs: ["imageClass", "imageStyle", "styleClass", "style", "src", "alt", "width", "height", "appendTo", "preview", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide", "onImageError"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i12.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i12.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i12.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i12.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i12.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i12.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i7.AsyncPipe, name: "async" }, { kind: "pipe", type: i7.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i7.LowerCasePipe, name: "lowercase" }, { kind: "pipe", type: i13.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormLoginComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-form-login', template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form\r\n      [formGroup]=\"loginForm\"\r\n      (ngSubmit)=\"onSubmitLogin()\"\r\n      novalidate\r\n      autocomplete=\"off\"\r\n    >\r\n      <div\r\n        class=\"text-center\"\r\n        [class]=\"{ 'my-3': imagePathLogo, 'my-1': !imagePathLogo }\"\r\n      >\r\n        <p-image [src]=\"imagePathLogo\" class=\"w-8\" alt=\"\"></p-image>\r\n      </div>\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 mb-4 text-center\"\r\n      >\r\n        {{ 'components.login.title' | translate | uppercase }}\r\n      </div>\r\n      <div class=\"px-5 mb-4\">\r\n        <h6 class=\"text-700\">\r\n          {{\r\n            ('entities.user.fields.email.label' | translate) +\r\n              ' ou ' +\r\n              ('entities.user.fields.token.unique_name.label'\r\n                | translate\r\n                | lowercase)\r\n          }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) +\r\n                ' ou ' +\r\n                ('entities.user.fields.token.unique_name.label'\r\n                  | translate\r\n                  | lowercase) +\r\n                '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autocomplete=\"off\"\r\n            autofocus\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n            [defaultValue]=\"authService.getStoredUserName()\"\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            loginForm.controls.email.touched && loginForm.controls.email.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"loginForm.controls.email.hasError('required')\"\r\n            >Email or username is required.</small\r\n          >\r\n        </div>\r\n      </div>\r\n      <div\r\n        class=\"px-5\"\r\n        [class]=\"{\r\n          'mb-3': showStoreUserName && showResetPasswordLink,\r\n          'mb-4': !showStoreUserName || !showResetPasswordLink\r\n        }\"\r\n      >\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.password.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i\r\n            class=\"pi pi-lock\"\r\n            (click)=\"onShowPassword()\"\r\n            style=\"cursor: pointer\"\r\n          ></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.password.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"password\"\r\n            id=\"password\"\r\n            autocomplete=\"off\"\r\n            [type]=\"showPassword ? 'text' : 'password'\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            loginForm.controls.password.touched &&\r\n            loginForm.controls.password.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"loginForm.controls.password.hasError('required')\"\r\n            >Password is required.</small\r\n          >\r\n        </div>\r\n      </div>\r\n\r\n      <div class=\"flex justify-content-between flex-wrap px-5 mb-4\">\r\n        <div\r\n          class=\"field-checkbox flex align-items-center justify-content-center\"\r\n          *ngIf=\"showStoreUserName\"\r\n        >\r\n          <p-checkbox\r\n            [(ngModel)]=\"checkedStoreUserName\"\r\n            formControlName=\"storeUserName\"\r\n            [binary]=\"true\"\r\n            inputId=\"storeUserName\"\r\n          ></p-checkbox>\r\n          <label for=\"storeUserName\" class=\"text-600 text-sm\">{{\r\n            'components.login.remember-me.label' | translate\r\n          }}</label>\r\n        </div>\r\n        <div\r\n          class=\"field flex align-items-center justify-content-center\"\r\n          *ngIf=\"showResetPasswordLink\"\r\n        >\r\n          <a\r\n            [style.pointer-events]=\"\r\n              (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n            \"\r\n            routerLink=\"{{\r\n              !(isLoadingData.visibility | async) ? resetPasswordPageRoute : ''\r\n            }}\"\r\n            class=\"underlineEffect text-sm blue-500 font-medium ml-1 cursor-pointer\"\r\n            style=\"text-decoration: none\"\r\n            >{{ 'components.login.forget-password-link.label' | translate }}</a\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"!loginForm.valid || (isLoadingData.visibility | async)\"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.login.button.label' | translate }}\"\r\n          icon=\"pi pi-unlock\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showSignUpRoute\">\r\n        <label class=\"text-600 text-sm\">{{\r\n          'components.login.question-account.label' | translate\r\n        }}</label>\r\n        <a\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          routerLink=\"{{ signUpPageRoute }}\"\r\n          class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.login.signup-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }, { type: i2.AbstractAuthService }, { type: i3.PrimeNGConfig }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: i4.Router }, { type: i5.IsLoadingDataService }]; }, propDecorators: { showStoreUserName: [{
                type: Input
            }], showResetPasswordLink: [{
                type: Input
            }], showSignUpRoute: [{
                type: Input
            }], signUpPageRoute: [{
                type: Input
            }], loginOkRedirectLink: [{
                type: Input
            }], resetPasswordPageRoute: [{
                type: Input
            }], imagePathLogo: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicHJnLWZvcm0tbG9naW4uY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2F1dGgvY29tcG9uZW50cy9mb3JtLWxvZ2luL3ByZy1mb3JtLWxvZ2luLmNvbXBvbmVudC50cyIsIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy9hdXRoL2NvbXBvbmVudHMvZm9ybS1sb2dpbi9wcmctZm9ybS1sb2dpbi5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0sRUFBRSxLQUFLLEVBQXFCLE1BQU0sZUFBZSxDQUFDO0FBQzVFLE9BQU8sRUFBRSxXQUFXLEVBQUUsU0FBUyxFQUFFLFVBQVUsRUFBRSxNQUFNLGdCQUFnQixDQUFDO0FBT3BFLE9BQU8sRUFBRSxlQUFlLEVBQUUsTUFBTSxzRUFBc0UsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7O0FBRXZHOztHQUVHO0FBTUgsTUFBTSxPQUFPLHFCQUFxQjtJQTBEaEMsNkpBQTZKO0lBRTdKOzs7Ozs7OztPQVFHO0lBQ0gsWUFDUyxNQUFpQixFQUNqQixXQUFnQyxFQUMvQixhQUE0QixFQUNILFVBQXlCLEVBQUUsd0hBQXdIO0lBQzVLLE1BQWMsRUFDZixhQUFtQztRQUxuQyxXQUFNLEdBQU4sTUFBTSxDQUFXO1FBQ2pCLGdCQUFXLEdBQVgsV0FBVyxDQUFxQjtRQUMvQixrQkFBYSxHQUFiLGFBQWEsQ0FBZTtRQUNILGVBQVUsR0FBVixVQUFVLENBQWU7UUFDbEQsV0FBTSxHQUFOLE1BQU0sQ0FBUTtRQUNmLGtCQUFhLEdBQWIsYUFBYSxDQUFzQjtRQTFFNUM7O1dBRUc7UUFDTSxzQkFBaUIsR0FBWSxJQUFJLENBQUM7UUFFM0M7O1dBRUc7UUFDTSwwQkFBcUIsR0FBWSxJQUFJLENBQUM7UUFDL0M7O1dBRUc7UUFDTSxvQkFBZSxHQUFZLElBQUksQ0FBQztRQUV6Qzs7V0FFRztRQUNNLG9CQUFlLEdBQ3RCLEdBQUc7WUFDSCxJQUFJLENBQUMsVUFBVSxDQUFDLG1CQUFtQjtZQUNuQyxHQUFHO1lBQ0gsSUFBSSxDQUFDLFVBQVUsQ0FBQyxxQkFBcUIsQ0FBQztRQUV4Qzs7V0FFRztRQUNNLHdCQUFtQixHQUMxQixHQUFHLEdBQUcsSUFBSSxDQUFDLFVBQVUsQ0FBQyw4QkFBOEIsQ0FBQztRQUV2RDs7V0FFRztRQUNNLDJCQUFzQixHQUM3QixHQUFHO1lBQ0gsSUFBSSxDQUFDLFVBQVUsQ0FBQyxtQkFBbUI7WUFDbkMsR0FBRztZQUNILElBQUksQ0FBQyxVQUFVLENBQUMsOEJBQThCLENBQUM7UUFFakQ7O1dBRUc7UUFDTSxrQkFBYSxHQUFXLEVBQUUsQ0FBQztRQUVwQzs7V0FFRztRQUNJLGlCQUFZLEdBQVksS0FBSyxDQUFDO1FBTXJDOztXQUVHO1FBQ0kseUJBQW9CLEdBQVksS0FBSyxDQUFDO0lBb0IxQyxDQUFDO0lBRUo7O09BRUc7SUFDSSxRQUFRO1FBQ2IsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsb0JBQW9CLENBQUMsQ0FBQztRQUN4QyxJQUFJLENBQUMsYUFBYSxFQUFFLENBQUM7UUFDckIsSUFBSSxDQUFDLFdBQVcsQ0FBQywyQkFBMkIsRUFBRSxDQUFDLFNBQVMsQ0FBQyxDQUFDLFNBQVMsRUFBRSxFQUFFO1lBQ3JFLElBQUksU0FBUyxFQUFFO2dCQUNiLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsQ0FBQztnQkFDckQsSUFBSSxDQUFDLG9CQUFvQixHQUFHLElBQUksQ0FBQzthQUNsQztRQUNILENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLEdBQUcsSUFBSSxDQUFDO0lBQ25DLENBQUM7SUFFRDs7T0FFRztJQUNJLFdBQVc7UUFDaEIsSUFBSSxDQUFDLE1BQU0sQ0FBQyxLQUFLLENBQUMsdUJBQXVCLENBQUMsQ0FBQztJQUM3QyxDQUFDO0lBRUQ7O09BRUc7SUFDSyxhQUFhO1FBQ25CLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxTQUFTLENBQzVCO1lBQ0UsS0FBSyxFQUFFLElBQUksV0FBVyxDQUFDLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUNuRCxLQUFLLEVBQUUsSUFBSSxXQUFXLEVBQUU7WUFDeEIsUUFBUSxFQUFFLElBQUksV0FBVyxDQUFDLElBQUksRUFBRSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUN0RCxhQUFhLEVBQUUsSUFBSSxXQUFXLENBQUMsSUFBSSxDQUFDO1NBQ3JDLEVBQ0QsRUFBRSxRQUFRLEVBQUUsUUFBUSxFQUFFLENBQ3ZCLENBQUM7SUFDSixDQUFDO0lBRUQ7O09BRUc7SUFFSSxjQUFjO1FBQ25CLElBQUksQ0FBQyxZQUFZLEdBQUcsQ0FBQyxJQUFJLENBQUMsWUFBWSxDQUFDO0lBQ3pDLENBQUM7SUFFRDs7T0FFRztJQUNJLEtBQUssQ0FBQyxhQUFhO1FBQ3hCLElBQUksSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLEVBQUU7WUFDMUIsT0FBTztTQUNSO1FBRUQsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQztRQUN0RCxNQUFNLFlBQVksR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsS0FBSyxDQUFDO1FBQzVELE1BQU0sYUFBYSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxLQUFLLENBQUM7UUFDbEUsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztRQUV6QixJQUFJO1lBQ0YsSUFDRSxNQUFNLElBQUksQ0FBQyxXQUFXLENBQUMsVUFBVSxDQUMvQixTQUFTLEVBQ1QsWUFBWSxFQUNaLGFBQWEsQ0FDZCxFQUNEO2dCQUNBLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxFQUFFLENBQUM7Z0JBQ3ZCLE1BQU0sSUFBSSxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxDQUFDO2FBQ3hEO1NBQ0Y7UUFBQyxPQUFPLEtBQUssRUFBRTtZQUNkLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1NBQzFCO1FBQ0QsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLEVBQUUsQ0FBQztJQUMxQixDQUFDOztrSEF2SlUscUJBQXFCLDJHQXlFdEIsZUFBZTtzR0F6RWQscUJBQXFCLGdXQ2xCbEMsZzdMQXNLQTsyRkRwSmEscUJBQXFCO2tCQUxqQyxTQUFTOytCQUNFLGdCQUFnQjs7MEJBNkV2QixNQUFNOzJCQUFDLGVBQWU7b0dBckVoQixpQkFBaUI7c0JBQXpCLEtBQUs7Z0JBS0cscUJBQXFCO3NCQUE3QixLQUFLO2dCQUlHLGVBQWU7c0JBQXZCLEtBQUs7Z0JBS0csZUFBZTtzQkFBdkIsS0FBSztnQkFTRyxtQkFBbUI7c0JBQTNCLEtBQUs7Z0JBTUcsc0JBQXNCO3NCQUE5QixLQUFLO2dCQVNHLGFBQWE7c0JBQXJCLEtBQUsiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBDb21wb25lbnQsIEluamVjdCwgSW5wdXQsIE9uRGVzdHJveSwgT25Jbml0IH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IEZvcm1Db250cm9sLCBGb3JtR3JvdXAsIFZhbGlkYXRvcnMgfSBmcm9tICdAYW5ndWxhci9mb3Jtcyc7XHJcbmltcG9ydCB7IFJvdXRlciB9IGZyb20gJ0Bhbmd1bGFyL3JvdXRlcic7XHJcbmltcG9ydCB7IE5HWExvZ2dlciB9IGZyb20gJ25neC1sb2dnZXInO1xyXG5pbXBvcnQgeyBQcmltZU5HQ29uZmlnIH0gZnJvbSAncHJpbWVuZy9hcGknO1xyXG5pbXBvcnQgeyBJc0xvYWRpbmdEYXRhU2VydmljZSB9IGZyb20gJy4uLy4uLy4uL2NvcmUvc2VydmljZXMvaXMtbG9hZGluZy1kYXRhL2lzbG9hZGluZ2RhdGEuc2VydmljZSc7XHJcbmltcG9ydCB7IFByZ0F1dGhDb25maWcgfSBmcm9tICcuLi8uLi9tb2RlbHMvcHJnLWF1dGgtY29uZmlnJztcclxuaW1wb3J0IHsgQWJzdHJhY3RBdXRoU2VydmljZSB9IGZyb20gJy4uLy4uL3NlcnZpY2VzL2F1dGgvYWJzdHJhY3QtYXV0aC5zZXJ2aWNlJztcclxuaW1wb3J0IHsgUFJHX0FVVEhfQ09ORklHIH0gZnJvbSAnLi4vLi4vc2VydmljZXMvcHJnLWF1dGgtY29uZmlndXJhdGlvbi9wcmctYXV0aC1jb25maWd1cmF0aW9uLnNlcnZpY2UnO1xyXG5cclxuLyoqXHJcbiAqIEZvcm0gTG9naW4gQ29tcG9uZW50XHJcbiAqL1xyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ3ByZy1mb3JtLWxvZ2luJyxcclxuICB0ZW1wbGF0ZVVybDogJy4vcHJnLWZvcm0tbG9naW4uY29tcG9uZW50Lmh0bWwnLFxyXG4gIHN0eWxlVXJsczogWycuL3ByZy1mb3JtLWxvZ2luLmNvbXBvbmVudC5zY3NzJ10sXHJcbn0pXHJcbmV4cG9ydCBjbGFzcyBQcmdGb3JtTG9naW5Db21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQsIE9uRGVzdHJveSB7XHJcbiAgLyoqXHJcbiAgICogU2hvd3MvaGlkZSB0aGUgY2hlY2tib3ggdG8gc2F2ZSB1c2VybmFtZSBvbiBsb2NhbCBzdG9yYWdlLiBEZWZhdWx0IHRydWUuXHJcbiAgICovXHJcbiAgQElucHV0KCkgc2hvd1N0b3JlVXNlck5hbWU6IGJvb2xlYW4gPSB0cnVlO1xyXG5cclxuICAvKipcclxuICAgKiBTaG93cy9oaWRlIHRoZSByZXNldCBwYXNzd29yZCBsaW5rLiAgRGVmYXVsdCB0cnVlLlxyXG4gICAqL1xyXG4gIEBJbnB1dCgpIHNob3dSZXNldFBhc3N3b3JkTGluazogYm9vbGVhbiA9IHRydWU7XHJcbiAgLyoqXHJcbiAgICogU2hvd3MvaGlkZSBzaWduIHVwIGxpbmsuICBEZWZhdWx0IHRydWUuXHJcbiAgICovXHJcbiAgQElucHV0KCkgc2hvd1NpZ25VcFJvdXRlOiBib29sZWFuID0gdHJ1ZTtcclxuXHJcbiAgLyoqXHJcbiAgICogVGhlIHJvdXRlIGZvciBzaWdudXAgcGFnZVxyXG4gICAqL1xyXG4gIEBJbnB1dCgpIHNpZ25VcFBhZ2VSb3V0ZTogc3RyaW5nID1cclxuICAgICcvJyArXHJcbiAgICB0aGlzLmF1dGhSb3V0ZXMuYXV0aFJvdXRpbmdCYXNlUGF0aCArXHJcbiAgICAnLycgK1xyXG4gICAgdGhpcy5hdXRoUm91dGVzLmF1dGhSb3V0aW5nU2lnbnVwUGF0aDtcclxuXHJcbiAgLyoqXHJcbiAgICogVGhlIHJvdXRlIHRvIHJlZGlyZWN0IGFmdGVyIGxvZ2luIHN1Y2Nlc3NcclxuICAgKi9cclxuICBASW5wdXQoKSBsb2dpbk9rUmVkaXJlY3RMaW5rOiBzdHJpbmcgPVxyXG4gICAgJy8nICsgdGhpcy5hdXRoUm91dGVzLmF1dGhSb3V0aW5nTG9naW5Pa1JlZGlyZWN0UGF0aDtcclxuXHJcbiAgLyoqXHJcbiAgICogVGhlIHJvdXRlIGZvciByZXF1ZXN0IG5ldyBwYXNzd29yZFxyXG4gICAqL1xyXG4gIEBJbnB1dCgpIHJlc2V0UGFzc3dvcmRQYWdlUm91dGU6IHN0cmluZyA9XHJcbiAgICAnLycgK1xyXG4gICAgdGhpcy5hdXRoUm91dGVzLmF1dGhSb3V0aW5nQmFzZVBhdGggK1xyXG4gICAgJy8nICtcclxuICAgIHRoaXMuYXV0aFJvdXRlcy5hdXRoUm91dGluZ1JlcXVlc3RQYXNzd29yZFBhdGg7XHJcblxyXG4gIC8qKlxyXG4gICAqIFByb3BlcnR5IG9mIHRoZSBjbGFzcyB3aXRoIHR5cGUgc3RyaW5nIHdoaWNoIGJpbmQgdG8gaW1hZ2UgbG9nbyBmb3JtLlxyXG4gICAqL1xyXG4gIEBJbnB1dCgpIGltYWdlUGF0aExvZ286IHN0cmluZyA9ICcnO1xyXG5cclxuICAvKipcclxuICAgKiBTaG93cy9oaWRlIHBhc3N3b3JkIG9uIGZvcm0uIERlZmF1bHQgZmFsc2UuXHJcbiAgICovXHJcbiAgcHVibGljIHNob3dQYXNzd29yZDogYm9vbGVhbiA9IGZhbHNlO1xyXG5cclxuICAvKipcclxuICAgKiBQcm9wZXJ0eSBvZiB0aGUgY2xhc3Mgd2l0aCB0eXBlIEZvcm0gR3JvdXAgd2hpY2ggYmluZCB0byB0aGUgcmVnaXN0ZXIgZm9ybVxyXG4gICAqL1xyXG4gIHB1YmxpYyBsb2dpbkZvcm06IEZvcm1Hcm91cDtcclxuICAvKipcclxuICAgKiBQcm9wZXJ0eSBvZiB0aGUgY2xhc3Mgd2l0aCB0eXBlIGJvb2xlYW4gd2hpY2ggYmluZCB0byB0aGUgY2hlY2tib3ggXCJSZW1lbWJlciBtZVwiXHJcbiAgICovXHJcbiAgcHVibGljIGNoZWNrZWRTdG9yZVVzZXJOYW1lOiBib29sZWFuID0gZmFsc2U7XHJcblxyXG4gIC8vIEdDUjogc3RyaW5ncyBkZXZlbSBzZXIgcGVsaWNhcyAoJycpIGVtIHZleiBkZSBhc3BhcyAoXCJcIikuIGVzdMOhIGNvbmZpZ3VyYWQgbm8gcHJldGllciBkZXZlbW9zIGNvcnJlciB1bSBjb21hbmRvIHBhcmEgY29ycmVyIG8gcHJldGllciBlbSB0b2RvcyBvcyBmaWNoZWlyb3NcclxuXHJcbiAgLyoqXHJcbiAgICogY29uc3RydWN0b3JcclxuICAgKiBAcGFyYW0ge05HWExvZ2dlcn0gbG9nZ2VyIGxvZ2dlclxyXG4gICAqIEBwYXJhbSB7QWJzdHJhY3RBdXRoU2VydmljZX0gYXV0aFNlcnZpY2UgYXV0aFNlcnZpY2VcclxuICAgKiBAcGFyYW0ge1ByaW1lTkdDb25maWd9IHByaW1lbmdDb25maWdcclxuICAgKiBAcGFyYW0ge1ByZ0F1dGhDb25maWd9IGF1dGhSb3V0ZXNcclxuICAgKiBAcGFyYW0ge1JvdXRlcn0gcm91dGVyXHJcbiAgICogQHBhcmFtIHtJc0xvYWRpbmdEYXRhU2VydmljZX0gaXNMb2FkaW5nRGF0YSBpc0xvYWRpbmdEYXRhXHJcbiAgICovXHJcbiAgY29uc3RydWN0b3IoXHJcbiAgICBwdWJsaWMgbG9nZ2VyOiBOR1hMb2dnZXIsXHJcbiAgICBwdWJsaWMgYXV0aFNlcnZpY2U6IEFic3RyYWN0QXV0aFNlcnZpY2UsXHJcbiAgICBwcml2YXRlIHByaW1lbmdDb25maWc6IFByaW1lTkdDb25maWcsXHJcbiAgICBASW5qZWN0KFBSR19BVVRIX0NPTkZJRykgcHJpdmF0ZSBhdXRoUm91dGVzOiBQcmdBdXRoQ29uZmlnLCAvLyBHQ1I6IHVzYXIgc2VtcHJlIG8gYXV0aENvbmZpZyBkaXJldGFtZW50ZSBzZW0gREkgfCBSZXNwIDogRMOhIHVtIGVycm8gZGUgZGVwZW5kZW5jaWEgY2lyY3VsYXIgYW8gdXRpbGl6YXIgbyBhdXRoQ29uZmlnXHJcbiAgICBwcml2YXRlIHJvdXRlcjogUm91dGVyLFxyXG4gICAgcHVibGljIGlzTG9hZGluZ0RhdGE6IElzTG9hZGluZ0RhdGFTZXJ2aWNlXHJcbiAgKSB7fVxyXG5cclxuICAvKipcclxuICAgKiBuZ09uSW5pdFxyXG4gICAqL1xyXG4gIHB1YmxpYyBuZ09uSW5pdCgpOiB2b2lkIHtcclxuICAgIHRoaXMubG9nZ2VyLmRlYnVnKCdMT0dJTiBGT1JNIE9OIElOSVQnKTtcclxuICAgIHRoaXMuaW5pdEZvcm1Mb2dpbigpO1xyXG4gICAgdGhpcy5hdXRoU2VydmljZS5nZXRTdG9yZWRVc2VyTmFtZU9ic2VydmFibGUoKS5zdWJzY3JpYmUoKHVzZXJFbWFpbCkgPT4ge1xyXG4gICAgICBpZiAodXNlckVtYWlsKSB7XHJcbiAgICAgICAgdGhpcy5sb2dpbkZvcm0uY29udHJvbHNbJ2VtYWlsJ10uc2V0VmFsdWUodXNlckVtYWlsKTtcclxuICAgICAgICB0aGlzLmNoZWNrZWRTdG9yZVVzZXJOYW1lID0gdHJ1ZTtcclxuICAgICAgfVxyXG4gICAgfSk7XHJcbiAgICB0aGlzLnByaW1lbmdDb25maWcucmlwcGxlID0gdHJ1ZTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIG5nT25EZXN0cm95XHJcbiAgICovXHJcbiAgcHVibGljIG5nT25EZXN0cm95KCk6IHZvaWQge1xyXG4gICAgdGhpcy5sb2dnZXIuZGVidWcoJ0xPR0lOIEZPUk0gT04gREVTVFJPWScpO1xyXG4gIH1cclxuXHJcbiAgLyoqXHJcbiAgICogSW5pdGlhdGUgdGhlIGxvZ2luIGZvcm0gYW5kIGl0cyBmb3JtIGNvbnRyb2xzIHdpdGggdmFsaWRhdG9yc1xyXG4gICAqL1xyXG4gIHByaXZhdGUgaW5pdEZvcm1Mb2dpbigpOiB2b2lkIHtcclxuICAgIHRoaXMubG9naW5Gb3JtID0gbmV3IEZvcm1Hcm91cChcclxuICAgICAge1xyXG4gICAgICAgIGVtYWlsOiBuZXcgRm9ybUNvbnRyb2wobnVsbCwgW1ZhbGlkYXRvcnMucmVxdWlyZWRdKSxcclxuICAgICAgICBjaGVjazogbmV3IEZvcm1Db250cm9sKCksXHJcbiAgICAgICAgcGFzc3dvcmQ6IG5ldyBGb3JtQ29udHJvbChudWxsLCBbVmFsaWRhdG9ycy5yZXF1aXJlZF0pLFxyXG4gICAgICAgIHN0b3JlVXNlck5hbWU6IG5ldyBGb3JtQ29udHJvbChudWxsKSxcclxuICAgICAgfSxcclxuICAgICAgeyB1cGRhdGVPbjogJ2NoYW5nZScgfVxyXG4gICAgKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIFNob3cvSGlkZSB0aGUgcGFzc3dvcmQgb24gbG9naW4gZm9ybVxyXG4gICAqL1xyXG5cclxuICBwdWJsaWMgb25TaG93UGFzc3dvcmQoKTogdm9pZCB7XHJcbiAgICB0aGlzLnNob3dQYXNzd29yZCA9ICF0aGlzLnNob3dQYXNzd29yZDtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIEZvcm0gc3VibWlzc2lvblxyXG4gICAqL1xyXG4gIHB1YmxpYyBhc3luYyBvblN1Ym1pdExvZ2luKCk6IFByb21pc2U8dm9pZD4ge1xyXG4gICAgaWYgKHRoaXMubG9naW5Gb3JtLmludmFsaWQpIHtcclxuICAgICAgcmV0dXJuO1xyXG4gICAgfVxyXG5cclxuICAgIGNvbnN0IHVzZXJFbWFpbCA9IHRoaXMubG9naW5Gb3JtLmNvbnRyb2xzLmVtYWlsLnZhbHVlO1xyXG4gICAgY29uc3QgdXNlclBhc3N3b3JkID0gdGhpcy5sb2dpbkZvcm0uY29udHJvbHMucGFzc3dvcmQudmFsdWU7XHJcbiAgICBjb25zdCBzdG9yZVVzZXJOYW1lID0gdGhpcy5sb2dpbkZvcm0uY29udHJvbHMuc3RvcmVVc2VyTmFtZS52YWx1ZTtcclxuICAgIHRoaXMubG9naW5Gb3JtLmRpc2FibGUoKTtcclxuXHJcbiAgICB0cnkge1xyXG4gICAgICBpZiAoXHJcbiAgICAgICAgYXdhaXQgdGhpcy5hdXRoU2VydmljZS5sb2dpbkFzeW5jKFxyXG4gICAgICAgICAgdXNlckVtYWlsLFxyXG4gICAgICAgICAgdXNlclBhc3N3b3JkLFxyXG4gICAgICAgICAgc3RvcmVVc2VyTmFtZVxyXG4gICAgICAgIClcclxuICAgICAgKSB7XHJcbiAgICAgICAgdGhpcy5sb2dpbkZvcm0ucmVzZXQoKTtcclxuICAgICAgICBhd2FpdCB0aGlzLnJvdXRlci5uYXZpZ2F0ZShbdGhpcy5sb2dpbk9rUmVkaXJlY3RMaW5rXSk7XHJcbiAgICAgIH1cclxuICAgIH0gY2F0Y2ggKGVycm9yKSB7XHJcbiAgICAgIHRoaXMubG9nZ2VyLmRlYnVnKGVycm9yKTtcclxuICAgIH1cclxuICAgIHRoaXMubG9naW5Gb3JtLmVuYWJsZSgpO1xyXG4gIH1cclxufVxyXG4iLCI8ZGl2IGNsYXNzPVwiZmxleCBqdXN0aWZ5LWNvbnRlbnQtY2VudGVyXCI+XHJcbiAgPGRpdlxyXG4gICAgY2xhc3M9XCJtYWluQ29udGFpbmVyIHNoYWRvdy0zIGJvcmRlci0xIGJvcmRlci0zMDAgc3VyZmFjZS1jYXJkIGJvcmRlci1yb3VuZC1sZyB3LTI4cmVtXCJcclxuICA+XHJcbiAgICA8Zm9ybVxyXG4gICAgICBbZm9ybUdyb3VwXT1cImxvZ2luRm9ybVwiXHJcbiAgICAgIChuZ1N1Ym1pdCk9XCJvblN1Ym1pdExvZ2luKClcIlxyXG4gICAgICBub3ZhbGlkYXRlXHJcbiAgICAgIGF1dG9jb21wbGV0ZT1cIm9mZlwiXHJcbiAgICA+XHJcbiAgICAgIDxkaXZcclxuICAgICAgICBjbGFzcz1cInRleHQtY2VudGVyXCJcclxuICAgICAgICBbY2xhc3NdPVwieyAnbXktMyc6IGltYWdlUGF0aExvZ28sICdteS0xJzogIWltYWdlUGF0aExvZ28gfVwiXHJcbiAgICAgID5cclxuICAgICAgICA8cC1pbWFnZSBbc3JjXT1cImltYWdlUGF0aExvZ29cIiBjbGFzcz1cInctOFwiIGFsdD1cIlwiPjwvcC1pbWFnZT5cclxuICAgICAgPC9kaXY+XHJcbiAgICAgIDxkaXZcclxuICAgICAgICBjbGFzcz1cInRleHQtNjAwIHRleHQtMnhsIHctZnVsbCBib3JkZXItYm90dG9tLTEgYm9yZGVyLXRvcC0xIGJvcmRlci0zMDAgcC0yIG1iLTQgdGV4dC1jZW50ZXJcIlxyXG4gICAgICA+XHJcbiAgICAgICAge3sgJ2NvbXBvbmVudHMubG9naW4udGl0bGUnIHwgdHJhbnNsYXRlIHwgdXBwZXJjYXNlIH19XHJcbiAgICAgIDwvZGl2PlxyXG4gICAgICA8ZGl2IGNsYXNzPVwicHgtNSBtYi00XCI+XHJcbiAgICAgICAgPGg2IGNsYXNzPVwidGV4dC03MDBcIj5cclxuICAgICAgICAgIHt7XHJcbiAgICAgICAgICAgICgnZW50aXRpZXMudXNlci5maWVsZHMuZW1haWwubGFiZWwnIHwgdHJhbnNsYXRlKSArXHJcbiAgICAgICAgICAgICAgJyBvdSAnICtcclxuICAgICAgICAgICAgICAoJ2VudGl0aWVzLnVzZXIuZmllbGRzLnRva2VuLnVuaXF1ZV9uYW1lLmxhYmVsJ1xyXG4gICAgICAgICAgICAgICAgfCB0cmFuc2xhdGVcclxuICAgICAgICAgICAgICAgIHwgbG93ZXJjYXNlKVxyXG4gICAgICAgICAgfX1cclxuICAgICAgICA8L2g2PlxyXG4gICAgICAgIDxzcGFuIGNsYXNzPVwicC1pbnB1dC1pY29uLWxlZnQgdy1mdWxsXCJcclxuICAgICAgICAgID48aSBjbGFzcz1cImJpIGJpLWVudmVsb3BlXCI+PC9pPlxyXG4gICAgICAgICAgPGlucHV0XHJcbiAgICAgICAgICAgIHBsYWNlaG9sZGVyPVwie3tcclxuICAgICAgICAgICAgICAoJ2VudGl0aWVzLnVzZXIuZmllbGRzLmVtYWlsLnBsYWNlaG9sZGVyJyB8IHRyYW5zbGF0ZSkgK1xyXG4gICAgICAgICAgICAgICAgJyBvdSAnICtcclxuICAgICAgICAgICAgICAgICgnZW50aXRpZXMudXNlci5maWVsZHMudG9rZW4udW5pcXVlX25hbWUubGFiZWwnXHJcbiAgICAgICAgICAgICAgICAgIHwgdHJhbnNsYXRlXHJcbiAgICAgICAgICAgICAgICAgIHwgbG93ZXJjYXNlKSArXHJcbiAgICAgICAgICAgICAgICAnLi4uJ1xyXG4gICAgICAgICAgICB9fVwiXHJcbiAgICAgICAgICAgIGZvcm1Db250cm9sTmFtZT1cImVtYWlsXCJcclxuICAgICAgICAgICAgaWQ9XCJlbWFpbFwiXHJcbiAgICAgICAgICAgIGF1dG9jb21wbGV0ZT1cIm9mZlwiXHJcbiAgICAgICAgICAgIGF1dG9mb2N1c1xyXG4gICAgICAgICAgICB0eXBlPVwiZW1haWxcIlxyXG4gICAgICAgICAgICBjbGFzcz1cInctZnVsbFwiXHJcbiAgICAgICAgICAgIHBJbnB1dFRleHRcclxuICAgICAgICAgICAgW2RlZmF1bHRWYWx1ZV09XCJhdXRoU2VydmljZS5nZXRTdG9yZWRVc2VyTmFtZSgpXCJcclxuICAgICAgICAvPjwvc3Bhbj5cclxuICAgICAgICA8ZGl2XHJcbiAgICAgICAgICBjbGFzcz1cImZsZXggZmxleC1jb2x1bW4gbXQtMlwiXHJcbiAgICAgICAgICAqbmdJZj1cIlxyXG4gICAgICAgICAgICBsb2dpbkZvcm0uY29udHJvbHMuZW1haWwudG91Y2hlZCAmJiBsb2dpbkZvcm0uY29udHJvbHMuZW1haWwuZGlydHlcclxuICAgICAgICAgIFwiXHJcbiAgICAgICAgPlxyXG4gICAgICAgICAgPHNtYWxsXHJcbiAgICAgICAgICAgIGNsYXNzPVwicC1lcnJvciB3LW1heFwiXHJcbiAgICAgICAgICAgICpuZ0lmPVwibG9naW5Gb3JtLmNvbnRyb2xzLmVtYWlsLmhhc0Vycm9yKCdyZXF1aXJlZCcpXCJcclxuICAgICAgICAgICAgPkVtYWlsIG9yIHVzZXJuYW1lIGlzIHJlcXVpcmVkLjwvc21hbGxcclxuICAgICAgICAgID5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgPC9kaXY+XHJcbiAgICAgIDxkaXZcclxuICAgICAgICBjbGFzcz1cInB4LTVcIlxyXG4gICAgICAgIFtjbGFzc109XCJ7XHJcbiAgICAgICAgICAnbWItMyc6IHNob3dTdG9yZVVzZXJOYW1lICYmIHNob3dSZXNldFBhc3N3b3JkTGluayxcclxuICAgICAgICAgICdtYi00JzogIXNob3dTdG9yZVVzZXJOYW1lIHx8ICFzaG93UmVzZXRQYXNzd29yZExpbmtcclxuICAgICAgICB9XCJcclxuICAgICAgPlxyXG4gICAgICAgIDxoNiBjbGFzcz1cInRleHQtNzAwXCI+XHJcbiAgICAgICAgICB7eyAnZW50aXRpZXMudXNlci5maWVsZHMucGFzc3dvcmQubGFiZWwnIHwgdHJhbnNsYXRlIH19XHJcbiAgICAgICAgPC9oNj5cclxuICAgICAgICA8c3BhbiBjbGFzcz1cInAtaW5wdXQtaWNvbi1sZWZ0IHctZnVsbFwiXHJcbiAgICAgICAgICA+PGlcclxuICAgICAgICAgICAgY2xhc3M9XCJwaSBwaS1sb2NrXCJcclxuICAgICAgICAgICAgKGNsaWNrKT1cIm9uU2hvd1Bhc3N3b3JkKClcIlxyXG4gICAgICAgICAgICBzdHlsZT1cImN1cnNvcjogcG9pbnRlclwiXHJcbiAgICAgICAgICA+PC9pPlxyXG4gICAgICAgICAgPGlucHV0XHJcbiAgICAgICAgICAgIHBsYWNlaG9sZGVyPVwie3tcclxuICAgICAgICAgICAgICAoJ2VudGl0aWVzLnVzZXIuZmllbGRzLnBhc3N3b3JkLnBsYWNlaG9sZGVyJyB8IHRyYW5zbGF0ZSkgKyAnLi4uJ1xyXG4gICAgICAgICAgICB9fVwiXHJcbiAgICAgICAgICAgIGZvcm1Db250cm9sTmFtZT1cInBhc3N3b3JkXCJcclxuICAgICAgICAgICAgaWQ9XCJwYXNzd29yZFwiXHJcbiAgICAgICAgICAgIGF1dG9jb21wbGV0ZT1cIm9mZlwiXHJcbiAgICAgICAgICAgIFt0eXBlXT1cInNob3dQYXNzd29yZCA/ICd0ZXh0JyA6ICdwYXNzd29yZCdcIlxyXG4gICAgICAgICAgICBjbGFzcz1cInctZnVsbFwiXHJcbiAgICAgICAgICAgIHBJbnB1dFRleHRcclxuICAgICAgICAvPjwvc3Bhbj5cclxuICAgICAgICA8ZGl2XHJcbiAgICAgICAgICBjbGFzcz1cImZsZXggZmxleC1jb2x1bW4gbXQtMlwiXHJcbiAgICAgICAgICAqbmdJZj1cIlxyXG4gICAgICAgICAgICBsb2dpbkZvcm0uY29udHJvbHMucGFzc3dvcmQudG91Y2hlZCAmJlxyXG4gICAgICAgICAgICBsb2dpbkZvcm0uY29udHJvbHMucGFzc3dvcmQuZGlydHlcclxuICAgICAgICAgIFwiXHJcbiAgICAgICAgPlxyXG4gICAgICAgICAgPHNtYWxsXHJcbiAgICAgICAgICAgIGNsYXNzPVwicC1lcnJvciB3LW1heFwiXHJcbiAgICAgICAgICAgICpuZ0lmPVwibG9naW5Gb3JtLmNvbnRyb2xzLnBhc3N3b3JkLmhhc0Vycm9yKCdyZXF1aXJlZCcpXCJcclxuICAgICAgICAgICAgPlBhc3N3b3JkIGlzIHJlcXVpcmVkLjwvc21hbGxcclxuICAgICAgICAgID5cclxuICAgICAgICA8L2Rpdj5cclxuICAgICAgPC9kaXY+XHJcblxyXG4gICAgICA8ZGl2IGNsYXNzPVwiZmxleCBqdXN0aWZ5LWNvbnRlbnQtYmV0d2VlbiBmbGV4LXdyYXAgcHgtNSBtYi00XCI+XHJcbiAgICAgICAgPGRpdlxyXG4gICAgICAgICAgY2xhc3M9XCJmaWVsZC1jaGVja2JveCBmbGV4IGFsaWduLWl0ZW1zLWNlbnRlciBqdXN0aWZ5LWNvbnRlbnQtY2VudGVyXCJcclxuICAgICAgICAgICpuZ0lmPVwic2hvd1N0b3JlVXNlck5hbWVcIlxyXG4gICAgICAgID5cclxuICAgICAgICAgIDxwLWNoZWNrYm94XHJcbiAgICAgICAgICAgIFsobmdNb2RlbCldPVwiY2hlY2tlZFN0b3JlVXNlck5hbWVcIlxyXG4gICAgICAgICAgICBmb3JtQ29udHJvbE5hbWU9XCJzdG9yZVVzZXJOYW1lXCJcclxuICAgICAgICAgICAgW2JpbmFyeV09XCJ0cnVlXCJcclxuICAgICAgICAgICAgaW5wdXRJZD1cInN0b3JlVXNlck5hbWVcIlxyXG4gICAgICAgICAgPjwvcC1jaGVja2JveD5cclxuICAgICAgICAgIDxsYWJlbCBmb3I9XCJzdG9yZVVzZXJOYW1lXCIgY2xhc3M9XCJ0ZXh0LTYwMCB0ZXh0LXNtXCI+e3tcclxuICAgICAgICAgICAgJ2NvbXBvbmVudHMubG9naW4ucmVtZW1iZXItbWUubGFiZWwnIHwgdHJhbnNsYXRlXHJcbiAgICAgICAgICB9fTwvbGFiZWw+XHJcbiAgICAgICAgPC9kaXY+XHJcbiAgICAgICAgPGRpdlxyXG4gICAgICAgICAgY2xhc3M9XCJmaWVsZCBmbGV4IGFsaWduLWl0ZW1zLWNlbnRlciBqdXN0aWZ5LWNvbnRlbnQtY2VudGVyXCJcclxuICAgICAgICAgICpuZ0lmPVwic2hvd1Jlc2V0UGFzc3dvcmRMaW5rXCJcclxuICAgICAgICA+XHJcbiAgICAgICAgICA8YVxyXG4gICAgICAgICAgICBbc3R5bGUucG9pbnRlci1ldmVudHNdPVwiXHJcbiAgICAgICAgICAgICAgKGlzTG9hZGluZ0RhdGEudmlzaWJpbGl0eSB8IGFzeW5jKSA/ICdub25lJyA6ICdhdXRvJ1xyXG4gICAgICAgICAgICBcIlxyXG4gICAgICAgICAgICByb3V0ZXJMaW5rPVwie3tcclxuICAgICAgICAgICAgICAhKGlzTG9hZGluZ0RhdGEudmlzaWJpbGl0eSB8IGFzeW5jKSA/IHJlc2V0UGFzc3dvcmRQYWdlUm91dGUgOiAnJ1xyXG4gICAgICAgICAgICB9fVwiXHJcbiAgICAgICAgICAgIGNsYXNzPVwidW5kZXJsaW5lRWZmZWN0IHRleHQtc20gYmx1ZS01MDAgZm9udC1tZWRpdW0gbWwtMSBjdXJzb3ItcG9pbnRlclwiXHJcbiAgICAgICAgICAgIHN0eWxlPVwidGV4dC1kZWNvcmF0aW9uOiBub25lXCJcclxuICAgICAgICAgICAgPnt7ICdjb21wb25lbnRzLmxvZ2luLmZvcmdldC1wYXNzd29yZC1saW5rLmxhYmVsJyB8IHRyYW5zbGF0ZSB9fTwvYVxyXG4gICAgICAgICAgPlxyXG4gICAgICAgIDwvZGl2PlxyXG4gICAgICA8L2Rpdj5cclxuICAgICAgPGRpdiBjbGFzcz1cInB4LTUgbWItMyB0ZXh0LWNlbnRlclwiPlxyXG4gICAgICAgIDxidXR0b25cclxuICAgICAgICAgIHR5cGU9XCJzdWJtaXRcIlxyXG4gICAgICAgICAgW2Rpc2FibGVkXT1cIiFsb2dpbkZvcm0udmFsaWQgfHwgKGlzTG9hZGluZ0RhdGEudmlzaWJpbGl0eSB8IGFzeW5jKVwiXHJcbiAgICAgICAgICBwQnV0dG9uXHJcbiAgICAgICAgICBwUmlwcGxlXHJcbiAgICAgICAgICBsYWJlbD1cInt7ICdjb21wb25lbnRzLmxvZ2luLmJ1dHRvbi5sYWJlbCcgfCB0cmFuc2xhdGUgfX1cIlxyXG4gICAgICAgICAgaWNvbj1cInBpIHBpLXVubG9ja1wiXHJcbiAgICAgICAgICBjbGFzcz1cInctZnVsbFwiXHJcbiAgICAgICAgPjwvYnV0dG9uPlxyXG4gICAgICA8L2Rpdj5cclxuICAgICAgPGRpdiBjbGFzcz1cInB4LTUgbWItMyB0ZXh0LWNlbnRlclwiICpuZ0lmPVwic2hvd1NpZ25VcFJvdXRlXCI+XHJcbiAgICAgICAgPGxhYmVsIGNsYXNzPVwidGV4dC02MDAgdGV4dC1zbVwiPnt7XHJcbiAgICAgICAgICAnY29tcG9uZW50cy5sb2dpbi5xdWVzdGlvbi1hY2NvdW50LmxhYmVsJyB8IHRyYW5zbGF0ZVxyXG4gICAgICAgIH19PC9sYWJlbD5cclxuICAgICAgICA8YVxyXG4gICAgICAgICAgW3N0eWxlLnBvaW50ZXItZXZlbnRzXT1cIlxyXG4gICAgICAgICAgICAoaXNMb2FkaW5nRGF0YS52aXNpYmlsaXR5IHwgYXN5bmMpID8gJ25vbmUnIDogJ2F1dG8nXHJcbiAgICAgICAgICBcIlxyXG4gICAgICAgICAgcm91dGVyTGluaz1cInt7IHNpZ25VcFBhZ2VSb3V0ZSB9fVwiXHJcbiAgICAgICAgICBjbGFzcz1cInVuZGVybGluZUVmZmVjdCB0ZXh0LXNtIGJsdWUtNTAwIGZvbnQtbWVkaXVtIG1sLTEgdGV4dC1yaWdodCBjdXJzb3ItcG9pbnRlclwiXHJcbiAgICAgICAgICBzdHlsZT1cInRleHQtZGVjb3JhdGlvbjogbm9uZVwiXHJcbiAgICAgICAgICA+e3sgJ2NvbXBvbmVudHMubG9naW4uc2lnbnVwLWxpbmsubGFiZWwnIHwgdHJhbnNsYXRlIH19PC9hXHJcbiAgICAgICAgPlxyXG4gICAgICA8L2Rpdj5cclxuICAgIDwvZm9ybT5cclxuICA8L2Rpdj5cclxuPC9kaXY+XHJcbiJdfQ==